/*              Mauro Javier De Gennaro <mauro@minter.com.ar>           */

/* dns_manager.c <2.0> - DNS Manager Main module */

#include <stdio.h> 
#include <string.h>
#include <stdlib.h>
#include "visualadmin.h"

named_tb *namedlist=NULL;
int ndns=0;

void dns_list(int a);
void save_named();
void getNamedInfo(char *buf, char *name, char *file, char *forwarders, int type);

void dns_list(int a) {
char buf[1024],*s,*e,temp[100],*named=NULL;
int c=1,b=0;
FILE *named_fp;
named_fp=fopen(F_NAMED, "r");
if(!named_fp) critical("Error opening named file");
strcpy(dnsdir, "/etc");
while(fgets(buf, sizeof(buf), named_fp)) {
	ndns++;
	if(buf[0]=='d' & buf[1]=='i' & buf[2]=='r')
		sscanf(buf, "%*s %s", dnsdir);
}
if (dnsdir[strlen(dnsdir)-1]!='/') strcat(dnsdir,"/");
rewind(named_fp);
namedlist=malloc((ndns+3)*sizeof(named_tb));
if(namedlist==NULL) critical("Error in malloc()");
while(fgets(namedlist[c].buf, sizeof(namedlist[c].buf), named_fp)) { 
	namedlist[c].num=1 ; 
	c++; 
}
fclose(named_fp);
switch(a) {
	case 0:
		view_dnslist();
	case 1:
		s=data;
		c=1;
		while(c) {
			e=strstr(s,"num=");
			if(!e) {
				c=0;
				continue;
			}
			s=e+4;
			e=index(s,'&');
			if(!e) {
				c=0;
				continue;
			}
			strncpy(temp,s,e-s);
			temp[e-s]='\0';
			s=e+1;
			namedlist[atoi(temp)].num=0;
		}
		save_named();
		view_dnslist();
		break;
	case 2:
		get_var(data, temp, "num=");
		view_dnsedit(atoi(temp));
		break;
	case 3:
		get_var(data, temp, "num=");
		b=atoi(temp);
		if(!b) { b=ndns+1; ndns++; namedlist[b].num=1;}
		get_var(data, buf, "type=");
		sprintf(namedlist[b].buf,"%s     ",buf);
		if(!strcmp(buf,"primary")) c=0; else c=1;
		get_var(data, buf, "zonename=");
		if(strlen(buf)<=1) critical("You must fill the Zone Name field.");
		strcat(namedlist[b].buf,buf);
		strcat(namedlist[b].buf,"     ");
		if(c) {
			get_var(data, buf, "primary=");
			if(strlen(buf)<=1) critical("You must fill the Primary Server field.");
			strcat(namedlist[b].buf,buf);
			strcat(namedlist[b].buf,"     ");
		}
		get_var(data, temp, "filename=");
		if(strlen(temp)<=1) critical("You must fill the Zone File Name field.");
		strcat(namedlist[b].buf,temp);
		strcat(namedlist[b].buf,"\n");
		save_named();
		named=malloc(strlen(data));
		if(named==NULL) critical("Can't malloc()");
		get_var(data, named, "file=");
		sprintf(buf, "%s%s", dnsdir, temp);
		named_fp=fopen(buf,"w");
		if(!named_fp) critical("Unable to open name server zone file");
		dos2unix(named_fp, named);
		fclose(named_fp);
		break;
	default:
		critical("Several Error.");
}


}

void save_named() {
int c=1;
FILE *named_fp;
named_fp=fopen(F_NAMED, "w");
if(!named_fp) critical("Error opening named boot file for writing");
for(c=1;c<=ndns;c++)
	if(namedlist[c].num)
		fprintf(named_fp, "%s", namedlist[c].buf);
fclose(named_fp);

}

void getNamedInfo(char *buf, char *name, char *file, char *forwarders, int isSec) {
char temp_1[50],temp_2[50],temp_3[50],temp_4[50];

if(isSec) {
	strcpy(temp_1, ""); strcpy(temp_2, ""); strcpy(temp_3, ""); strcpy(temp_4, "");
	sscanf(buf, "%*s %s %s %s %s %s", name, temp_1, temp_2, temp_3, temp_4);
	if(strlen(temp_3)<=1) { 
		strcpy(forwarders, temp_1); 
		strcpy(file, temp_2); 
	} else if(strlen(temp_4)<=1) { 
		sprintf(forwarders, "%s %s", temp_1, temp_2); 
		strcpy(file, temp_3); 
	} else {
		sprintf(forwarders, "%s %s %s", temp_1, temp_2, temp_3);
		strcpy(file, temp_4);
	}
	
} else {
	sscanf(buf, "%*s %s %s", name, file);
}

}
