#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include "internal.h"
#include "userconf.h"
#include "../paths.h"
#include "userconf.m"

#define ETC_SHADOW_TMP	"/etc/shadow.tmp"
static USERCONF_HELP_FILE help_shadow ("shadow");
static CONFIG_FILE f_shadow (ETC_SHADOW,help_shadow,CONFIGF_MANAGED
	,"root","root",0600);



/*
	Used when reading the /etc/shadow file
*/
PUBLIC SHADOW::SHADOW(const char *line)
{
	char words[9][100];
	user_splitline (line,words);
	name.setfrom (words[0]);
	passwd.setfrom (words[1]);
	last = atoi(words[2]);
	may = atoi(words[3]);
	must = atoi(words[4]);
	warn = atoi(words[5]);
	expire = atoi(words[6]);
	disable = atoi(words[7]);
	reserved.setfrom(words[8]);
}

static const char K_SHADOW[]="shadow";
static const char K_DEFAULT[]="default";

static	int stdduration = 0;

/*
	Used when creating a new record
*/
PUBLIC SHADOW::SHADOW()
{
	last = 0; 
	may = 0; 
	must = 99999;
	warn = 0;
	expire = 0;
	disable = 0;
	const char *str = linuxconf_getval (K_SHADOW,K_DEFAULT);
	if (str != NULL){
		if (sscanf (str,"%d %d %d %d %d",&may,&must,&warn,&expire
			,&stdduration)==5){
			if (stdduration != 0){
				disable = time(NULL)/(24*60*60) + stdduration;
			}
		}
	}
}

/*
	Setup the part of the dialog for shadow default policies.
*/
PUBLIC void SHADOW::setdialog (DIALOG &dia)
{
	dia.newf_title ("",MSG_U(T_SHADEF,"Account management defaults"));
	dia.newf_num (MSG_R(F_PASSMAY),may);
	dia.newf_num (MSG_R(F_PASSMUST),must);
	dia.newf_num (MSG_R(F_PASSWARN),warn);
	dia.newf_num (MSG_R(F_PASSEXPIRE),expire);
	dia.newf_num (MSG_U(F_STDDURATION,"Standard account duration")
		,stdduration);
}

/*
	Save the default setting for shadow policies.
*/
PUBLIC int SHADOW::writedef()
{
	char buf[100];
	sprintf (buf,"%d %d %d %d %d",may,must,warn,expire,stdduration);
	linuxconf_replace (K_SHADOW,K_DEFAULT,buf);
	return linuxconf_save();
}

/*
	Return the crypt password field
*/
PUBLIC const char *SHADOW::getpwd()
{
	return passwd.get();
}
/*
	Write one record of /etc/passwd
*/
PUBLIC void SHADOW::write(FILE *fout)
{
	fprintf (fout,"%s:%s:%d:%d:%d:%d:%d:%d:%s\n"
		,name.get(),passwd.get(),last,may,must,warn,expire,disable
		,reserved.get());
}

PUBLIC SHADOWS::SHADOWS()
{
	/* #Specification: /etc/passwd / strategy
		/etc/shadow is read "by hand" instead of using getpwent() to avoid
		getting all those NIS entries. This is done when editing local
		user account.
	*/
	FILE *fin = f_shadow.fopen ("r");
	if (fin != NULL){
		char line[1000];
		while (fgets(line,sizeof(line)-1,fin)!=NULL){
			strip_end (line);
			if (line[0] != '\0'){
				add (new SHADOW(line));
			}
		}
		fclose (fin);
	}
	rstmodified();
}
PUBLIC SHADOW *SHADOWS::getitem(int no)
{
	return (SHADOW*)ARRAY::getitem(no);
}
/*
	Get one SHADOW specification of the table or NULL from his login name
*/
PUBLIC SHADOW *SHADOWS::getitem(const char *name)
{
	SHADOW *ret = NULL;
	int nbu = getnb();
	for (int i=0; i<nbu; i++){
 		SHADOW *usr = getitem(i);
		if (usr->name.cmp(name)==0){
			ret = usr;
			break;
		}
	}
	return ret;
}

PUBLIC int SHADOWS::write(PRIVILEGE *priv)
{
	int ret = -1;
	FILE *fout = f_shadow.fopen (priv,ETC_SHADOW_TMP,"w");
	if (fout != NULL){
		int nbu = getnb();
		for (int i=0; i<nbu; i++){
			getitem(i)->write(fout);
		}
		fclose(fout);
		unlink(ETC_SHADOW ".OLD");
		link(ETC_SHADOW, ETC_SHADOW ".OLD");
		unlink(ETC_SHADOW);
		link(ETC_SHADOW_TMP, ETC_SHADOW);
		unlink(ETC_SHADOW_TMP);
		ret = 0;
	}
	return ret;
}

/*
	Return != 0 if the /etc/shadow file exist
*/
int shadow_exist ()
{
	return f_shadow.exist();
}


