#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <misc.h>
#include <dialog.h>
#include "internal.h"
#include "userconf.h"
#include "../paths.h"
#include "userconf.m"

extern USERCONF_HELP_FILE help_password;

static const char PASSWD[] = "passwd";
static const char MINLEN[] = "minlen";
static const char MINNONALPHA[] = "minnonalpha";

static int passwd_valid_getval(const char *key, int defval)
{
	const char *pt = linuxconf_getval(PASSWD,key);
	if (pt != NULL) defval = atoi(pt);
	return defval;
}

PUBLIC void PASSWD_VALID::write()
{
	linuxconf_replace (PASSWD,MINLEN,minlen);
	linuxconf_replace (PASSWD,MINNONALPHA,minnonalpha);
	linuxconf_save();
}
PUBLIC PASSWD_VALID::PASSWD_VALID()
{
	minlen = passwd_valid_getval(MINLEN,6);
	minnonalpha = passwd_valid_getval(MINNONALPHA,0);
}

/*
	Edit the password setting policies
*/
PUBLIC void PASSWD_VALID::edit()
{
	if(perm_rootaccess(MSG_U(P_PASSPOLICIES
		,"set the password policies"))){
		DIALOG dia;
		dia.newf_num (MSG_U(F_MINLEN,"Minimum length"),minlen);
		dia.newf_num (MSG_U(F_MINCHARS,"Minimum amount of non alpha char")
			,minnonalpha);
		SHADOW sha;
		if (shadow_exist()){
			sha.setdialog (dia);
		}
		if (dia.edit (
			MSG_U(T_PASSPOLICIES,"Password setting policies")
			,MSG_U(I_PASSPOLICIES
			 ,"You must enter here the validation rules\n"
			  "for password. Once setup, a user (or you) won't\n"
			  "be able to change a password to one that does\n"
			  "fullfill this requirements\n")
			,help_password)==MENU_ACCEPT){
			write();
			if (shadow_exist()) sha.writedef();
		}
	}			
}

