/* #Specification: translation kit / message used before main
	The translation system has a problem when a message is needed before
	main has called translat_load(). Quite often, the message is
	not really needed, but a pointer to it must be store. This is often
	done in constructor of a static object, on in static table.

	The object TRANS_NOTLOAD has been created to record more info about
	the needed message and can provide the translation later with the
	member function TRANS_NOTLOAD::get().

	To ease the usage of this technique, the following macros are provided
	and created by msgscan when it created the header file.

	P_MSG_U(MSG_ID,"texte")
	P_MSG_R(MSG_ID)

	These macros both created a TRANS_NOTLOAD object (using new). A static
	table may be done like this

	static TRANS_NOTLOAD *tb[]={
		P_MSG_U(ID1,"id1"),
		P_MSG_U(ID2,"id2"),
	};
*/
#include <translat.h>

PUBLIC TRANS_NOTLOAD::TRANS_NOTLOAD (
	const char **&_table,
	int _nomsg)
	: table (_table)
{
	nomsg = _nomsg;
}

PUBLIC const char *TRANS_NOTLOAD::get()
{
	return table[nomsg];
}

TRANS_NOTLOAD *new_trans_notload (
	const char **&table,
	int nomsg)
{
	return new TRANS_NOTLOAD(table,nomsg);
}


