#include "netconf.h"
#include "internal.h"
#include <misc.h>
#include <dialog.h>
#include "netconf.m"

NETCONF_HELP_FILE help_routed ("routed");

static const char ROUTED_P[]="routed";
static const char REQUIRED[]="required";
static const char GATEWAY[]="gateway";
static const char SILENT[]="silent";


PUBLIC ROUTED::ROUTED()
{
	/* #Specification: netconf / routed / default operation
		Without configuration, netconf assume that the routed
		daemon is not required.

		At this time the routed daemon is reported to be
		broken (it looses routes), so I have decided not
		to run it by default. This should be the reverse
		in the future I guess. Comments ?
	*/
	required = linuxconf_getvalnum(ROUTED_P,REQUIRED,0);
	gateway = linuxconf_getvalnum(ROUTED_P,GATEWAY,0);
	silent = linuxconf_getvalnum(ROUTED_P,SILENT,1);
}

/*
	Save the configuration in /etc/conf.linuxconf
*/
PUBLIC void ROUTED::save()
{
	linuxconf_replace(ROUTED_P,REQUIRED,required);
	linuxconf_replace(ROUTED_P,GATEWAY,gateway);
	linuxconf_replace(ROUTED_P,SILENT,silent);
	linuxconf_save();
}

/*
	Should we start routed
*/
PUBLIC int ROUTED::is_required()
{
	return required;
}

/*
	Set the option of the command line to start routed.
*/
PUBLIC void ROUTED::setoptions(char *buf)
{
	buf[0] = '\0';
	/* #Specification: netconf / routed / options
		netconf support only the -s and -g option of routed.

		-s stands for silent. This means that routed only listen
		for route, does not publish anything.

		-g stands for gateway. Routed will publish its default
		route.
	*/
	if (silent){
		strcpy (buf,"-s");
	}else if (gateway){
		strcpy (buf,"-g");
	}
}

/*
	Return -1 if the edit was abort
*/
PUBLIC int ROUTED::edit()
{
	int ret = -1;
	DIALOG dia;
	dia.newf_chk ("",required,MSG_U(F_ROUTEDREQ,"routed is required"));
	dia.newf_chk ("",silent,MSG_U(F_NOEXPORT,"Does not export any routes (Silent)"));
	dia.newf_chk ("",gateway,MSG_U(F_EXPORTDEFRT,"Export your default route"));
	while (1){
		if (dia.edit(MSG_U(T_ROUTEDCONF,"Routed daemon configuration")
			,MSG_U(I_ROUTEDCONF
			 ,"Check the appropriate options\n"
			  "unless you have a simple network, routed\n"
			  "is required.\n")
			,help_routed)==MENU_ACCEPT){
			if (silent && gateway){
				xconf_error (MSG_U(E_CANTSILENT
					,"Can't be both silent and a gateway\n"));
			}else{
				save();
				ret = 0;
				break;
			}
		}else{
			break;
		}
	}
	if (ret == -1) dia.restore();
	return ret;
}

void routed_edit ()
{
	ROUTED r;
	r.edit();
}
	
	

