#pragma interface
#ifndef DIALPPP_H
#define DIALPPP_H

#define TYPE_PPP_SERIAL	0
#define TYPE_PPP_PAP	1	// Those two (PAP and CHAP) are not used
#define TYPE_PPP_CHAP	2	// anymore. They are differentiate from
							// standard PPP using the PPP_AUTH defines
							// For compatibility, the old definition
							// are translated when read
#define TYPE_SLIP		3
#define TYPE_PLIP1		4
#define TYPE_PLIP2		5
#define TYPE_PPP_SSH	6

#define PPP_AUTH_LOGIN	0
#define PPP_AUTH_PAP	1
#define PPP_AUTH_CHAP	2
#define PPP_AUTH_NONE	3


struct LK_STR{
	const char *key;
	SSTRING *str;
	const char *defval;
};
struct LK_INT{
	const char *key;
	int *num;
	int defval;
};
struct LK_CHAR{
	const char *key;
	char *num;
	char defval;
};

class PPPONE{
	SSTRING name;		// Symbolic name of the configuration
	SSTRING phone;
	SSTRING login;
	SSTRING passwd;
	SSTRING loginkey;	// String required before sending login
						// Normally ogin:
	SSTRING passwdkey;	// String required before sending the password
						// Normally assword:
	SSTRING loginok;	// optionnal confirmation string
						// telling the passwd was good
	SSTRING loginfail;	// optionnal string identifying a login failure
						// (password was wrong)
	SSTRING loginchat;	// Custom login chat in case the standard one
						// fail.
	SSTRING device;
	SSTRING modeminit;
	char type;	// TYPE_xxxx
	char defaultroute;
	char modem;	// Modem controls
	char lock;	// Set standard lock file
	char proxyarp;	// Establish proxyarp when connecting
	char pppauth;	// Type of PPP authentication
	int mru;
	int mtu;
	int baud;
	int idletime;
	char dbgppp;
	char dbgchat;
	SSTRING options;	// pppd options which are not
				// handled by this program
	SSTRING asyncmap;	// One specific important option of
				// pppd
	SSTRING ourip;		// Optionnal IP numbers
	SSTRING remoteip;
	SSTRING lcpecho;
	LK_STR strs[20];
	LK_INT nums[20];
	LK_CHAR chars[20];
	struct {
		SSTRING host;
		SSTRING user;
		SSTRING encrypt;
		SSTRING pppd_path;
		char compress;
		char via_shell;
	}ssh;
	PPPIPROUTES iproutes;
	/*~PROTOBEG~ PPPONE */
public:
	PPPONE (CONFDB&cfg, const char *_name);
	int connect (int fore);
private:
	int connect_plip (void);
	int connect_ppp (int fore);
	int connect_pppssh (int);
	int connect_slip (int);
protected:
	void del (CONFDB&cfg, const char *_name);
public:
	int disconnect (void);
private:
	int disconnect_plip (void);
	int disconnect_ppp (void);
	int disconnect_slip (void);
public:
	int edit (CONFDB&cfg);
	int getpppd_pid (void);
private:
	int lcpecho_parse (int &delay, int &retry);
	int lcpecho_valid (void);
public:
	int postconnect (const char *dev);
	int predisconnect (const char *);
	int save (CONFDB&cfg);
private:
	void setdia_iproute (DIALOG&dia, int no);
	void setipparam (char *str);
	void setuptbdb (void);
	int validate_edit (SSTRING&baudstr,
		 SSTRING&oldname,
		 CONFDB&cfg);
public:
	/*~PROTOEND~ PPPONE */
};

extern const char PPP_CHANNEL[];
extern const char linuxconf_dialout[];
extern const char linuxconf_dialin[];

#endif
