#pragma interface
#ifndef FIREWALL_H
#define FIREWALL_H

#ifndef MISC_H
	#include <misc.h>
#endif

struct IPFW_SRC{
	SSTRING host;
	SSTRING netmask;
	int nbbit_msk;		// Computed number of bit in the netmask
						// to speed up the sort.
	SSTRING portrange;
	SSTRING ports;
	SSTRING interface;	// eth0 ...
};

class IPFW_RULE: public ARRAY_OBJ{
	friend class IPFW_RULES;
protected:
	char active;		// Is this rules has been activated
				// by the user.
	SSTRING protocol;	// icmp, udp, tcp, all
	IPFW_SRC from;
	IPFW_SRC to;
public:
	virtual void save()=0;
	virtual int edit()=0;
	virtual int setup_left(int doit, SSTRING *collect, SSTRING &errmsg)=0;
	virtual int setup_right(int doit, SSTRING *collect, SSTRING &errmsg)=0;
	/*~PROTOBEG~ IPFW_RULE */
protected:
	IPFW_RULE (const char *&buf);
	IPFW_RULE (void);
public:
	int editk (DIALOG&dia, const char *title);
	int nbbitmask (IPFW_SRC&f);
	int nbbitmask_from (void);
	int nbbitmask_to (void);
	void present (char *buf);
protected:
	void savek (char *buf);
public:
	int setup (IPFW_SRC&f,
		 IPFW_SRC&t,
		 const char *type,
		 int doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
	/*~PROTOEND~ IPFW_RULE */
};

class IPFW_RULE_FORWARD: public IPFW_RULE{
	char masquerade;	// Masquerade while forwarding ?
	/*~PROTOBEG~ IPFW_RULE_FORWARD */
public:
	IPFW_RULE_FORWARD (const char *buf);
	IPFW_RULE_FORWARD (void);
	int edit (void);
	void save (void);
	int setup_left (int doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
	int setup_right (int doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
	/*~PROTOEND~ IPFW_RULE_FORWARD */
};

class IPFW_RULE_OUTPUT: public IPFW_RULE{
	/*~PROTOBEG~ IPFW_RULE_OUTPUT */
public:
	IPFW_RULE_OUTPUT (const char *buf);
	IPFW_RULE_OUTPUT (void);
	int edit (void);
	void save (void);
	int setup_left (int doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
	int setup_right (int doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
	/*~PROTOEND~ IPFW_RULE_OUTPUT */
};

class IPFW_RULE_INPUT: public IPFW_RULE{
	/*~PROTOBEG~ IPFW_RULE_INPUT */
public:
	IPFW_RULE_INPUT (const char *buf);
	IPFW_RULE_INPUT (void);
	int edit (void);
	void save (void);
	int setup_left (int doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
	int setup_right (int doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
	/*~PROTOEND~ IPFW_RULE_INPUT */
};

extern char FIREWALL[];
extern char FORWARD[];
extern char BLOCK[];
extern char OUTPUT[];

#endif
