#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <dialog.h>
#include "misc.h"

/*
	Input a string or a password.
	Return 0 if the input is successful (no Escape, no Cance).
	Return -1 if anything else.
*/
static MENU_STATUS xconf_inputbox0 (
	const char *title,	// Window's title
	const char *explan,	// Explanation of the selection to do
	HELP_FILE &helpfile,	// Help file or help_nil
	char buffer[MAX_LEN+1],	// Buffer for input.
	MENU_STATUS (*fct)(const char *, const char *, HELP_FILE &, char buffer[MAX_LEN+1]))
{
	dialog_clear();
	return (*fct) (title,explan	,helpfile,buffer);
}

/*
	Input a string in a box.
*/
MENU_STATUS xconf_inputbox (
	const char *title,	// Window's title
	const char *explan,	// Explanation of the selection to do
	HELP_FILE &helpfile,	// Help file or help_nil
	char buffer[MAX_LEN+1])	// Buffer for input.
{
	return xconf_inputbox0 (title,explan,helpfile,buffer,dialog_inputbox);
}
/*
	Input a password in a box.
	Return 0 if the input is successful (no Escape, no Cance).
	Return -1 if anything else.
*/
MENU_STATUS xconf_inputpass (
	const char *title,	// Window's title
	const char *explan,	// Explanation of the selection to do
	HELP_FILE &helpfile,	// Help file or help_nil
	char buffer[MAX_LEN+1])	// Buffer for input.
{
	html_setpopup();
	return xconf_inputbox0 (title,explan,helpfile,buffer,dialog_inputpass);
}
/*
	Multiple field dialog. See dialog/multi_inputbox.

	Return MENU_ACCEPT, MENU_CANCEL or MENU_ESCAPE

	If edit != 0, minstr[] will be modified only if the user select OK (and
	the function return 0).

	If edit == 0, minstr[] will be either set to '\0' or will contain the
	input of the user if he selected OK.
 */
MENU_STATUS xconf_multiinp(
	const char *title,			// Main title
	const char *intro,			// Mini help describing the purpose
								// of the dialog
	HELP_FILE &helpfile,		// Help file or help_nil
	const char *prompts[],		// Title of each field
	char minstr[][MAX_LEN+1],	// Input field
	int nbfield,				// Number of input field
	int edit,					// Edit current value or reset to '\0'
	int nof)					// Start editing on which field
{
	DIALOG dia;
	for (int i=0; i<nbfield; i++){
		if (!edit) minstr[i][0] = '\0';
		dia.newf_str (prompts[i],minstr[i],MAX_LEN);
	}
	return dia.edit (title,intro,helpfile,nof);
}

/*
	Display a dialog box with a list of options that can be turned on or off
	Wrapper for HELP_FILE management.
*/
int xconf_checklist(
	const char *title,
	const char *prompt,
	HELP_FILE &helpfile,		// Help file or help_nil
	int list_height,
	int item_no,
	char **items,
	char *status)		/* Array of flags indicating if items[x] is */
						/* selected */
{
	return dialog_checklist (title,prompt,helpfile
		,list_height,item_no,items,status);
}

