#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "misc.h"

/*
	Strips all blank and line feed at the end of a string
  	newstr and str may be the same string.
	Return the number of bytes striped at the end.
*/
int str_strip (
	const char *str,	// String to truncate
	char *newstr)		// result
{
	int ret = 0;
	int len = strlen(str);
	char *pt = newstr + len-1;
	strcpy (newstr,str);
	while (len > 0 && isspace(*pt)){
		*pt-- = '\0';
		len --;
		ret ++;
	}
	return (ret);
}
/*
	Strip all blank (white space) at the end of a line.
	blanks are identified by isspace().
	Return a pointer to the last character +1 (right on the '\0', the
	new one).

	ATTENTION: To help cooperate with some DOS editor, ^Z is processed
	as a white space.
*/

char *strip_end(char *str)
{
	int len = strlen(str);
	for (str += len - 1
		; len > 0 && (isspace(*str) || *str == 26)
		; len--, str--) *str = '\0';
	return str+1;
}
/*
	Skip the white space in a string. Stop at the end or at the first
	non white space.
*/
char *str_skip(const char *str)
{
	while (isspace(*str)) str++;
	return (char*)str;
}
/*
	Skip the digit space in a string. Stop at the end or at the first
	non digit character.
*/
char *str_skipdig(const char *str)
{
	while (isdigit(*str)) str++;
	return (char*)str;
}

/*
	Copy one word from a string. A word is a sequence of non white space.
	Return a pointer on the first blank character after the word.

	If there were no word, dest[0] == '\0'
*/

char *str_copyword(char *dest, const char *str)
{
	str = str_skip(str);
	while (isgraph(*str)) *dest++ = *str++;
	*dest = '\0';
	return (char*) str;
}
/*
	Move over one word
*/

char *str_skipword(const char *str)
{
	str = str_skip(str);
	while (isgraph(*str)) str++;
	str = str_skip(str);
	return (char*) str;
}
/*
	Copy one word from a string. A word is a sequence of non white space.
	Return a pointer on the first blank character after the word.

	If there were no word, dest[0] == '\0'
*/

char *str_copyword(SSTRING &dest, const char *str)
{
	str = str_skip(str);
	char tmp[1000];
	char *pt = tmp;
	while (isgraph(*str)) *pt++ = *str++;
	*pt = '\0';
	dest.setfrom (tmp);
	return (char*) str;
}

/*
	Free all entry of the string table.
*/
void tbstr_free (char *tb[], int nb)
{
	for (int i=0; i<nb; i++) free (tb[i]);
}

/*
	Why is it missing ?
*/
int stricmp (const char *str1, const char *str2)
{
	int ret = 0;
	while (1){
		if (*str1 == '\0'){
			if (*str2 != 0){
				ret = -1;
			}
			break;
		}else if (*str2 == '\0'){
			ret = 1;
			break;
		}else{
			int car1 = toupper(*str1);
			int car2 = toupper(*str2);
			ret = car1 - car2;
			if (ret != 0) break;
			str1++;
			str2++;
		}
	}
	return ret;
}


void strupr(char *str)
{
	while (*str != '\0'){
		*str = toupper(*str);
		str++;
	}
}

/*
	Extract a string from a buffer.
	The string may be a single word or many words enclose in
	double quote.
*/
const char *str_extract (const char *buf, SSTRING &s)
{
	buf = str_skip(buf);
	char word[200];
	if (*buf == '"'){
		buf++;
		char *pt = word;
		while (*buf != '\0' && * buf != '"') *pt++ = *buf++;
		*pt = '\0';
		if (*buf == '"') buf++;
	}else{
		buf = str_copyword (word,buf);
	}
	s.setfrom (word);
	return buf;
}

