#include <string.h>
#include "misc.h"

/*
	Read a line of a configuration file and process continuation line.
	Return buf, or NULL si eof
	Blank at the end of line are always stripped.
	Everything following comcar is a comment. The line is cut before.
*/
char *fgets_strip (
	char *buf,
	int sizebuf,
	FILE *fin,
	char contcar,		// Continuation char, generally backslash
	char comcar,		// Comment character, generally #
	int *noline,		// This will be updated and contain the line number
						// Can be NULL
	int *empty)			// Will be != 0 if the line is empty and did not
						// even hold a comment.
{
	int nocomment = 1;		// No comments found ?
	int contline=0;
	char *debut = buf;
	char *ret = NULL;
	*buf = '\0';
	*empty = 1;
	while (fgets(buf,sizebuf,fin)!=NULL){
		char *end = strip_end (buf);
		char *pt = strchr(buf,comcar);
		if (pt != NULL){
			nocomment = 0;
			*pt = '\0';
			end = strip_end (buf);
		}
		if (noline != NULL) (*noline)++;
		ret = debut;
		if (contline){
			char *pt = str_skip(buf);
			if (pt > buf+1){
				strcpy (buf+1,pt);
				buf[0] = ' ';
				end-=(int)(pt-buf)-1;
			}else if (pt == buf+1){
				buf[0] = ' ';
			}
		}
		if (end > buf && *(end-1) == contcar){
			if (end == buf+1 || *(end-2) != contcar){
				/* Continuation demand */
				contline = 1;
				end--;
				*end = '\0';
				buf = end;
			}else{
				*(end-1) = '\0';
				break;
			}
		}else{
			break;
		}
	}
	*empty = debut[0] == '\0' && nocomment;
	return ret;
}		

/*
	Read a line of a configuration file and process continuation line.
	Return buf, or NULL si eof
	Blank at the end of line are always stripped.
	Everything following comcar is a comment. The line is cut before.
*/
char *fgets_strip (
	char *buf,
	int sizebuf,
	FILE *fin,
	char contcar,		// Continuation char, generally backslash
	char comcar,		// Comment character, generally #
	int *noline)		// This will be updated and contain the line number
						// Can be NULL
{
	int empty;
	return fgets_strip (buf,sizebuf,fin,contcar,comcar,noline,&empty);
}

/*
	Read a line of a configuration file and process continuation line.
	Return buf, or NULL si eof
	Blank at the end of line are always stripped.
	Everything following comcar is a comment. The line is cut before.

	Continuation character is \
	Comment character is #
*/
char *fgets_strip (
	char *buf,
	int sizebuf,
	FILE *fin,
	int *noline)		// This will be updated and contain the line number
						// Can be NULL
{
	int empty;
	return fgets_strip (buf,sizebuf,fin,'\\','#',noline,&empty);
}

/*
	Read a line of text and process continuation lines
	unlike fgets_strip, comment are return untouched.

	Return -1 if end of file, 0 if ok
*/
int fgets_cont (char *buf, int size, FILE *fin)
{
	int ret = -1;
	char tmp[500];
	buf[0] = '\0';
	while (fgets(tmp,size,fin) != NULL){
		char sbuf[500];
		str_strip(tmp,sbuf);
		int len = strlen(sbuf);
		strcpy (buf,sbuf);
		buf += len;
		size -= len;
		ret = 0;
		if (len == 0 || sbuf[len-1] != '\\') break;
		*--buf = '\0';
		size++;
	}
	return ret;
}

/*
	Read lines and accumulate comments.
	buf will contain the first non comment, non empty line.
*/
const char *fgets_comments (
	char buf[],
	int size,
	FILE *fin,
	SSTRING &comments)
{
	comments.setfrom ("");
	const char *ret = NULL;
	while (fgets_cont(buf,size,fin)!=-1){
		strip_end (buf);
		char *pt = str_skip (buf);
		if (pt[0] == '\0' || pt[0] == '#'){
			/* #Specification: fgets_comment / strategy
				When parsing comment out of a configuration file, only
				the text is kept (the # is striped). This helps the
				edit process. Comments should be written back with
				comment_write().
			*/
			if (pt[0] == '#') pt = str_skip(pt+1);
			strcat (buf,"\n");
			comments.append (pt);
		}else{
			ret = buf;
			break;
		}
	}
	return ret;
}


/*
	Write back a bunch of comment lines
*/
void comment_write (const SSTRING &str, FILE *fout)
{
	const char *pt = str.get();
	while (*pt != '\0'){
		const char *begin = pt;
		pt = strchr(pt,'\n');
		if (pt == begin){
			fputc('\n',fout);
			pt++;
		}else if (pt != NULL){
			char line[1000];
			char *ptl = line;
			while (begin < pt) *ptl++ = *begin++;
			*ptl = '\0';
			fprintf (fout,"# %s\n",line);
			pt++;
		}else{
			fprintf (fout,"# %s\n",begin);
				break;
		}
	}
}

