#pragma interface
#ifndef CONFIGF_H
#define CONFIGF_H

/*
	This class record help file path and serve as a runtime check
	that there is no help file missing.
*/
class HELP_FILE{
	friend void helpf_checkall();
	const char *subdir;
	const char *fname;
	char *path;		// Dynamically allocated buffer containing
					// the resolved path.
	HELP_FILE *next;
	/*~PROTOBEG~ HELP_FILE */
public:
	HELP_FILE (const char *_subdir, const char *_fname);
	const char *getpath (void);
	void getrpath (char *rpath);
	/*~PROTOEND~ HELP_FILE */
};

extern HELP_FILE help_nil;	// Object to specify that there is
							// no help file available.

#define CONFIGF_NONE		0
#define CONFIGF_MANAGED		1		// linuxconf do edit this file
#define CONFIGF_PRIVATE		2		// Only root can see this
#define CONFIGF_OPTIONNAL	4		// Don't complain if the file
									// is missing.
#define CONFIGF_GENERATED	8		// linuxconf do not edit
									// the file, but generate it.
#define CONFIGF_PROBED		16		// This file is checked to
									// control a daemon						
#define CONFIGF_ERASED		32		// Erased at boot time

class PRIVILEGE;

class CONFIG_FILE{
	friend void configf_show();
	friend void configf_booterase();
	CONFIG_FILE *next;
	const char *stdpath;
	const char *realpath;	// The admin may move file around!
	HELP_FILE &helpf;
	int status;		// See CONFIGF_XXXXX
	const char *owner;
	const char *group;
	int perm;
	/*~PROTOBEG~ CONFIG_FILE */
public:
	CONFIG_FILE (const char *_path,
		 HELP_FILE&_helpfile,
		 int _status);
	CONFIG_FILE (const char *_path,
		 HELP_FILE&_helpfile,
		 int _status,
		 const char *_owner,
		 const char *_group,
		 int _perm);
	void editpath (void);
	int exist (void)const;
private:
	void fixpath (void)const;
public:
	FILE *fopen (PRIVILEGE *priv,
		 const char *mode)const;
	FILE *fopen (PRIVILEGE *priv,
		 const char *temp,
		 const char *mode)const;
	FILE *fopen (const char *mode)const;
	FILE *fopen (const char *temp,
		 const char *mode)const;
	FILE *fopen_ok (const char *mode)const;
	long getdate (void)const;
	const char *gethelp (void)const;
	const char *getpath (void)const;
	const char *getstdpath (void)const;
private:
	void init (const char *_path,
		 int _status,
		 const char *_owner,
		 const char *_group,
		 int _perm);
public:
	int is_erased (void)const;
	int is_generated (void)const;
	int is_managed (void)const;
	int is_optionnal (void)const;
	int is_probed (void)const;
	int setperm (const char *fpath)const;
	int unlink (void)const;
	~CONFIG_FILE (void);
	/*~PROTOEND~ CONFIG_FILE */
};

#endif
