#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <misc.h>
#include "internal.h"
#include "../paths.h"
#include <netconf.h>
#include "mailconf.m"

extern MAILCONF_HELP_FILE help_mailconf;

CONFIG_FILE f_sendmail (ETC_SENDMAIL_CF,help_mailconf
	,CONFIGF_GENERATED|CONFIGF_OPTIONNAL|CONFIGF_PROBED);


/*
	Avoid repeating the same path over and over
*/
class MAILCONF_FILE: public CONFIG_FILE{
public:
	MAILCONF_FILE(const char *fname);
};

static const char *setpath(const char *fname)
{
	char buf[200];
	sprintf (buf,"%s/mailconf/%s.cf",USR_LIB_LINUXCONF,fname);
	return strdup(buf);
}

PUBLIC MAILCONF_FILE::MAILCONF_FILE(const char *fname)
	: CONFIG_FILE (setpath(fname),help_mailconf,CONFIGF_NONE)
{
}

static MAILCONF_FILE f_intro ("intro");
static MAILCONF_FILE f_copyright ("copyright");
static MAILCONF_FILE f_stdmacros ("stdmacros");
static MAILCONF_FILE f_stdoptions ("stdoptions");

static MAILCONF_FILE f_rulesets ("rulesets");
static MAILCONF_FILE f_rulesets_s0_intro ("rulesets.s0.intro");
static MAILCONF_FILE f_rulesets_s0_90 ("rulesets.s0.90");
static MAILCONF_FILE f_rulesets_s0_local ("rulesets.s0.local");
static MAILCONF_FILE f_rulesets_s0_remote ("rulesets.s0.remote");
static MAILCONF_FILE f_rulesets_s3 ("rulesets.s3");
static MAILCONF_FILE f_rulesets_s90 ("rulesets.s90");
static MAILCONF_FILE f_rulesets_s96_dns ("rulesets.s96.dns");
static MAILCONF_FILE f_rulesets_s96_nodns ("rulesets.s96.nodns");
static MAILCONF_FILE f_rulesets_s96_fewdns ("rulesets.s96.fewdns");

static MAILCONF_FILE f_localmailer ("localmailer.std");
static MAILCONF_FILE f_delivermailer ("localmailer.deliver");
static MAILCONF_FILE f_procmailmailer ("localmailer.procmail");
static MAILCONF_FILE f_progmailer ("progmailer");
static MAILCONF_FILE f_uucpmailer ("uucpmailer.std");
static MAILCONF_FILE f_virtmailer ("virtualmailer.std");
//static MAILCONF_FILE f_uucpnbmailer ("uucpmailer.nobatch");
static MAILCONF_FILE f_smtpmailer ("smtpmailer.std");

static MAILCONF_FILE f_localmailer_tst ("localmailer.tst");
static MAILCONF_FILE f_uucpmailer_tst ("uucpmailer.tst");
static MAILCONF_FILE f_smtpmailer_tst ("smtpmailer.tst");

const int TOKEN_VALLEN = 40;
/*
	Copy a text file into fout with token replacement
	Return 0 if ok, -1 if any error.
*/
static int copyfile (
	CONFIG_FILE &filesrc,
	FILE *fout,
	const char *token[],
	const char repl[][TOKEN_VALLEN],
	int nbtoken)
{
	int ret = -1;
	FILE *fin = filesrc.fopen("r");
	if (fin != NULL){
		ret = 0;
		char buf[1000];
		while (fgets(buf,sizeof(buf)-1,fin)!=NULL){
			for (int i=0; i<nbtoken; i++){
				const char *tok = token[i];
				char *pt = strstr(buf,tok);
				if (pt != NULL){
					char buf2[1000];
					int len = (int)(pt-buf);
					memcpy (buf2,buf,len);
					strcpy (buf2+len,repl[i]);
					strcat (buf2,buf+len+strlen(tok));
					strcpy (buf,buf2);
				}
			}
			fputs (buf,fout);
		}
		fclose (fin);
	}
	return ret;
}

/*
	Copy a text file into fout.
	Return 0 if ok, -1 if any error.
*/
static int copyfile (CONFIG_FILE &filesrc, FILE *fout)
{
	return copyfile (filesrc,fout,NULL,NULL,0);
}

/*
	Produce the file /etc/sendmail.cf using the configuration.

	It mail generate the normal sendmail.cf or a temporary one
	for automated test purpose (If its argument is true).
	Not implemented yet.

	Return -1 if any error
*/
PUBLIC int MAILCONF::generate(bool)
{
	int ret = -1;
	FILE *fout = f_sendmail.fopen ("w");
	if (fout != NULL){
		ret = copyfile (f_intro,fout);
		ret |= copyfile (f_copyright,fout);
		THISHOST thishost;
		const char *hname = thishost.getname1();
		fputs ("# Alias for this host\n",fout);
		fprintf (fout,"Cw localhost %s\n",hname);
		int i;
		for (i=0; i<alias.getnb(); i++){
			fprintf (fout,"Cw %s\n",alias.getitem(i)->get());
		}
		fputs ("# Virtual email domain\n",fout);
		VDOMAINS vdomains;		// Virtual domains
		for (i=0; i<vdomains.getnb(); i++){
			fprintf (fout,"CV %s\n",vdomains.getitem(i)->domain.get());
		}
		//fputc ('\n',fout);

		fputs ("# who I masquerade as (null for no masquerading)\n",fout);
		const char *masquerade = hname;
		if (!mailas.is_empty()) masquerade = mailas.get();
		fprintf (fout,"DM%s\n",masquerade);

		/* #Specification: mailconf / sendmail.cf / smarthost
			If we specify that we are our own smarthost, this
			is causing problem with sendmail. It could be
			argue that it makes sens (independant of sendmail).

			Given also that linuxconf mail configuration
			will be shareable one day, this makes sens.

			When we detect that the smarthost is this host
			we simply ignore it (The S macro of sendmail.cf
			remain empty).

			We do the same for the mailhost (Macro H of
			sendmail.cf)
		*/
		fputs ("# Smart host\n",fout);
		if (smarthost.icmp(hname)==0){
			fputs  ("DS\n",fout);
		}else{
			fprintf  (fout,"DS%s\n",smarthost.get());
		}
		fputs ("# Use this mailer to reach the Smart host\n",fout);
		fprintf  (fout,"DN%s\n",smartmailer.get());

		fputs ("# Central host for local mail\n",fout);
		if (mailhost.icmp(hname)==0){
			fputs  ("DH\n",fout);
		}else{
			fprintf (fout,"DH%s\n",mailhost.get());
		}

		fputs ("# class L: names that should be delivered locally, even if we have a relay\n",fout);
		fprintf (fout,"CL%s\n",users.deliverlocal.get());

		fputs ("# class E: names that should be exposed as from this host, even if we masquerade\n",fout);
		fprintf (fout,"CE%s\n",users.dontmasque.get());

		fputs ("# Database for special routing\n",fout);
		if (features.mailertable){
			fprintf (fout,"Kmailertable %s /var/lib/mailertable\n"
				,features.dbformat.get());
		}else{
			fputs("# Not activated\n",fout);
			if (spcs.getnb()>0){
				xconf_notice(MSG_U(E_MTABLEON
					,"The /etc/sendmail.cf will be generated without\n"
					 "special (domain) routing enabled. This system\n"
					 "has already some special routing definition(s)\n"
					 "and this sendmail.cf won't make use of them.\n"
					 "Enable \"special routing database\" in the\n"
					 "\"basic information\" dialog to fix this\n"
					 "and regenerate the sendmail.cf."));
			}
		}

		fputs ("# Restrict DNS to those domain only\n",fout);
		fputs ("CD ",fout);
		int restricted_dns = 0;
		for (i=0; i<dnsfor.getnb(); i++){
			SSTRING *item = dnsfor.getitem(i);
			if (!item->is_empty()) restricted_dns = 1;
			fprintf (fout," %s",item->get());
		}
		fputc ('\n',fout);

		ret |= copyfile (f_stdmacros,fout);

		fputs ("# Deliver mail only in DNS is available\n",fout);
		fputs (features.dnsneeded ? "OI\n" : "#OI\n", fout);

		ret |= copyfile (f_stdoptions,fout);
		ret |= copyfile (f_rulesets,fout);
		if (features.mailertable) ret |= copyfile (f_rulesets_s90,fout);
		ret |= copyfile (f_rulesets_s0_intro,fout);
		COMPLEX_ROUTES cplx;
		cplx.rule0 (fout,alias);
		ret |= copyfile (f_rulesets_s0_local,fout);
		if (features.mailertable) ret |= copyfile (f_rulesets_s0_90,fout);
		ret |= copyfile (f_rulesets_s0_remote,fout);

		ret |= copyfile (f_rulesets_s3,fout);
		if (features.nodns){
			ret |= copyfile (f_rulesets_s96_nodns,fout);
		}else if (restricted_dns){
			ret |= copyfile (f_rulesets_s96_fewdns,fout);
		}else{
			ret |= copyfile (f_rulesets_s96_dns,fout);
		}
		if (deliver.is_empty()){
			if (file_exist ("/bin/mail.local")){
				ret |= copyfile (f_localmailer,fout);
			}else if (file_exist ("/usr/bin/deliver")){
				ret |= copyfile (f_delivermailer,fout);
			}else if (file_exist ("/usr/bin/procmail")){
				ret |= copyfile (f_procmailmailer,fout);
			}
		}else if (deliver.cmp("deliver")==0){
			ret |= copyfile (f_delivermailer,fout);
		}else if (deliver.cmp("procmail")==0){
			ret |= copyfile (f_procmailmailer,fout);
		}
		ret |= copyfile (f_progmailer,fout);
		ret |= copyfile (f_virtmailer,fout);
		static const char *uucptoken[]={
			"$(MAXSIZ)","$(UUXOPT)"
		};
		char uucprepl[2][TOKEN_VALLEN];
		uucprepl[0][0] = '\0';
		if (features.uucpmax > 0){
			sprintf (uucprepl[0],"M=%d,",features.uucpmax);
		}
		strcpy (uucprepl[1],features.uucpnobatch ? "" : "-r");
		ret |= copyfile (f_uucpmailer,fout
			,uucptoken,uucprepl,2);
		ret |= copyfile (f_smtpmailer,fout);
		fclose (fout);
		if (features.mailertable) spcs.build(features.dbformat.get());
		if (ret != -1){
			xconf_notice (MSG_U(N_HASGEN,"%s has been regenerated!")
				,f_sendmail.getpath());
		}
	}
	return ret;
}
	

