#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <misc.h>
#include "internal.h"
#include "../paths.h"

static const char MAILCONF[] = "mailconf";

static const char *confread_getval (const char *key, const char *defval)
{
	const char *val = linuxconf_getval(MAILCONF,key);
	if (val == NULL){
		val = defval;
	}
	return val;
}

static int confread_getval(const char *key, int defval)
{
	char valstr[20];
	sprintf (valstr,"%d",defval);
	return atoi(confread_getval(key,valstr));
}

static void confread_getall (const char *key, SSTRINGS &strs)
{
	linuxconf_getall (MAILCONF,key,strs,1);
}

static const char DNSNEEDED[] = "dnsneeded";
static const char NODNS[] = "nodns";
static const char UUCPNOBATCH[] = "uucpnobatch";
static const char DBFORMAT[] = "dbformat";
static const char DONTMASQUE[] = "dontmasque";
static const char DELIVERLOCAL[] = "deliverlocal";
static const char SMARTHOST[] = "smarthost";
static const char MAILHOST[] = "mailhost";
static const char SMARTMAILER[] = "smartmailer";
static const char ALIASES[] = "aliases";
static const char MAILAS[] = "mailas";
static const char UUCPMAX[] = "uucpmax";
static const char DELIVER[] = "deliver";
static const char MAILERTABLE[] = "mailertable";

PUBLIC MAILCONF::MAILCONF()
{
	features.uucpmax = confread_getval(UUCPMAX,200000);
	features.dnsneeded = confread_getval(DNSNEEDED,0);
	features.nodns = confread_getval(NODNS,0);
	features.uucpnobatch = confread_getval(UUCPNOBATCH,1);
	features.mailertable = confread_getval (MAILERTABLE,0);
	features.dbformat.setfrom (confread_getval(DBFORMAT,"dbm"));
	users.dontmasque.setfrom (confread_getval(DONTMASQUE,"root"));
	users.deliverlocal.setfrom (confread_getval(DELIVERLOCAL,"root"));
	smarthost.setfrom (confread_getval(SMARTHOST,""));
	mailhost.setfrom (confread_getval(MAILHOST,""));
	smartmailer.setfrom (confread_getval(SMARTMAILER,"smtp"));
	confread_getall (ALIASES,alias);
	mailas.setfrom (confread_getval(MAILAS,""));
	deliver.setfrom (confread_getval(DELIVER,""));
}

static void confread_replace (const char *key, const char *val)
{
	linuxconf_replace (MAILCONF,key,val);
}

static void confread_replace (const char *key, const SSTRING &val)
{
	confread_replace (key,val.get());
}

static void confread_replace (const char *key, int val)
{
	char valstr[10];
	sprintf (valstr,"%d",val);
	confread_replace (key,valstr);
}

static void confread_replace (const char *key, const SSTRINGS &vals)
{
	linuxconf_replace (MAILCONF,key,vals);
}

/*
	Write sendmail configuration in /etc/conf.linuxconf
*/
PUBLIC int MAILCONF::write()
{
	confread_replace (DNSNEEDED,features.dnsneeded);
	confread_replace (UUCPMAX,features.uucpmax);
	confread_replace (NODNS,features.nodns);
	confread_replace (MAILERTABLE,features.mailertable);
	confread_replace (UUCPNOBATCH,features.uucpnobatch);
	confread_replace (DBFORMAT,features.dbformat);
	confread_replace (MAILHOST,mailhost);
	confread_replace (SMARTHOST,smarthost);
	confread_replace (SMARTMAILER,smartmailer);
	confread_replace (MAILAS,mailas);
	confread_replace (DELIVERLOCAL,users.deliverlocal);
	confread_replace (DONTMASQUE,users.dontmasque);
	confread_replace (ALIASES,alias);
	confread_replace (DELIVER,deliver);
	return linuxconf_save();
}

