#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include "internal.h"

PUBLIC TBFILE::TBFILE(
	const char *_defpath)	// Default path
{
	defpath = strdup(_defpath);
	nbopen = 0;
	cur = NULL;
}

PUBLIC TBFILE::~TBFILE()
{
	while (nbopen > 0) ::fclose (tb[--nbopen]);
	free (defpath);
}


/*
	Open a new file and remember the one currently open.
	(put in on a stack). fclose will get it back.

	Return the FILE handle or NULL if can't open.
*/
PUBLIC FILE *TBFILE::fopen (const char *fname, const char *mode)
{
	char abspath[PATH_MAX];
	if (fname[0] != '/'){
		sprintf (abspath,"%s/%s",defpath,fname);
		fname = abspath;
	}
	FILE *ret = xconf_fopen (fname,mode);
	if (ret != NULL){
		tb[nbopen++] = ret;
		cur = ret;
	}
	return ret;
}

PUBLIC void TBFILE::fclose ()
{
	if (nbopen > 0){
		::fclose (cur);
		cur = NULL;
		nbopen--;
		if (nbopen > 0) cur = tb[nbopen-1];
	}
}

