#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <limits.h>
#include <sys/stat.h>
#include "internal.h"
#include "dnsconf.h"
#include "dnsconf.m"

static DNSCONF_HELP_FILE help_secondary("secondary");


PUBLIC SECONDARY::SECONDARY(
	const char *_domain,
	const char *_backup,
	const char **_ip_addr,
	int nb_ip)
{
	domain.setfrom (_domain);
	backup.setfrom (_backup);
	for (int i=0; i<nb_ip; i++) addr[i].setfrom(_ip_addr[i]);
}

PUBLIC SECONDARY::SECONDARY()
{
}

PUBLIC void SECONDARY::write(FILE *fout, const char *named_dir) const
{
	fprintf (fout,"secondary\t%s",domain.get());
	for (int i=0; i<4; i++){
		fprintf (fout," %s",addr[i].get());
	}
	if (backup.is_empty){
		/* #Specification: secondary / backup file / location
			dnsconf set the backup file in the subdirectory
			"sec" of the DNS configuration directory.
			It simply use the domain as the name of the file.

			You can override this by editing /etc/named.boot by
			hand. dnsconf will preserve the new path.

			The "sec" subdirectory will be created automaticly.
		*/
		char path[PATH_MAX];
		sprintf (path,"%s/sec",named_dir);
		mkdir (path,0755);
		fprintf (fout,"\tsec/%s\n",domain.get());
	}else{
		fprintf (fout,"\t%s\n",backup.get());
	}
}


/*
	Edit the minimal spec so this dns will act as a secondary for another
	Return -1 if the user escaped away.
	Return  0 if the changes are accepted
	Return  1 if the user wish to delete this entry
*/
PUBLIC int SECONDARY::edit()
{
	DIALOG dia;
	dia.newf_str (MSG_R(F_DOMAIN),domain);
	dia.newf_str (MSG_U(F_IPSERV,"IP address of the server"),addr[0]);
	dia.newf_str ("",addr[1]);
	dia.newf_str ("",addr[2]);
	dia.newf_str ("",addr[3]);
	int ret = -1;
	int nof = 0;
	while (1){
		MENU_STATUS status = dia.edit (
			 MSG_U(T_SECSPEC,"Secondary specification")
			,MSG_U(I_SECSPEC
			 ,"You must enter a domain and at least IP address\n"
			  "of one DNS server of that domain\n")
			,help_secondary
			,nof
			,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_DEL);
		if (status == MENU_CANCEL || status == MENU_ESCAPE){
			break;
		}else if (status == MENU_DEL){
			if (xconf_areyousure(MSG_U(Q_DELSECONDARY
				,"Confirm deletion of a secondary spec"))){
				ret = 1;
				break;
			}
		}else{
			if (domain.is_empty()
				|| addr[0].is_empty()){
				xconf_error(MSG_U(E_FILLDOM
					,"Fill at least the domain\n"
					 "and the first IP address"));
			}else{
				ret = 0;
				break;
			}
		}
	}
	if (ret != 0) dia.restore();
	return ret;
}

PUBLIC SECONDARY *SECONDARYS::getitem (int no) const
{
	return (SECONDARY*)ARRAY::getitem(no);
}

PUBLIC void SECONDARYS::write (FILE *fout, const char *named_dir) const
{
	for (int i=0; i<getnb(); i++) getitem(i)->write(fout,named_dir);
}

PUBLIC void SECONDARYS::edit(DNS &dns)
{
	int choice=0;
	while (1){
		int nb = getnb();
		const char **menuopt = (const char**)malloc((nb*2+1)*sizeof(char*));
		int ii=0;
		for (int i=0; i<nb; i++){
			menuopt[ii++] = " ";
			menuopt[ii++] = getitem(i)->domain.get();
		}
		menuopt[ii] = NULL;
		MENU_STATUS code = xconf_menu (MSG_U(T_SECONDARYS,"Secondaries")
			,MSG_U(I_SECONDARYS
				,"You are allowed to edit/add/remove secondaries\n")
			,help_secondary
			,NULL
			,NULL
			,NULL
			,MSG_U(I_ADDSEC,"to add one secondary spec")
			,menuopt,choice);
		free (menuopt);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ADD){
			SECONDARY *sec = new SECONDARY;
			if (sec->edit()==0){
				add (sec);
				dns.write();
			}else{
				delete sec;
			}
		}else{
			SECONDARY *sec = getitem(choice);
			int ok = sec->edit();
			if (ok != -1){
				if (ok == 1) remove_del (sec);
				dns.write();
			}
		}
	}
}

