#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "dnsconf.h"
#include "internal.h"

/*
	Replace or add a record in this DOMAIN definition.
	new_rec has been created with new. It will be managed (even deleted)
	by this function.
*/
PUBLIC int PRIMARY::set (FQHOST &fq, RECORD *new_rec)
{
	/* #Specification: record file / multiple origin
		dnsconf can update with multiple $ORIGIN statement.
		It will find the closest origin.
	*/
	ORIGIN *match_ori = NULL;
	int minlevel = 100;
	for (int i=0; i<origins.getnb(); i++){
		ORIGIN *ori = origins.getitem(i);
		char hostpart[200];
		int level = fq.is_member(ori->origin.get(),hostpart);
		if (level > 0 && level < minlevel){
			match_ori = ori;
			new_rec->sethostpart(hostpart);
			minlevel = level;
		}
	}
	if (match_ori != NULL){
		match_ori->tbrec.add (new_rec);
		updatesoa();
	}
	return 0;
}
/*
	Erase a record in this DOMAIN definition.
	new_rec has been created with new. It is used to find the record
	to delete. It is also deleted by this function.
*/
PUBLIC int PRIMARY::unset (RECORD *new_rec)
{
	bool found = false;
	for (int i=0; i<origins.getnb() && !found; i++){
		ORIGIN *ori = origins.getitem(i);
		for (int o=0; o<ori->tbrec.getnb(); o++){
			RECORD *rec = ori->tbrec.getitem(o);
			if (rec->cmp(new_rec) == 0){
				ori->tbrec.remove_del(rec);
				o--;
				found = true;
			}
		}
	}
	if (found) updatesoa();
	delete new_rec;
	return 0;
}


/*
	Locate all record of a type using the left value has the key.
*/
PUBLIC int PRIMARY::locate_left (
	FQHOST &fq,
	RECORD_TYPE rtype,
	RECORDS &recs)
{
	recs.neverdelete();
	for (int i=0; i<origins.getnb(); i++){
		ORIGIN *ori = origins.getitem(i);
		char hostpart[200];
		int level = fq.is_member(ori->origin.get(),hostpart);
		if (level > 0){
			for (int o=0; o<ori->tbrec.getnb(); o++){
				RECORD *rec = ori->tbrec.getitem(o);
				if (rec->is (rtype)
					&& rec->cmp_left (hostpart)==0){
					recs.add (rec);
				}
			}
		}
	}
	return recs.getnb();
}

