#include <stdio.h>
#include <string.h>
#include <misc.h>
#include "dnsconf.h"
#include "internal.h"
#include "../paths.h"
#include "dnsconf.m"

DNSCONF_HELP_FILE help_dnsedit ("edit");

/*
	Edit a host or sub-domain information.
	 -A and PTR record) globally.
	 -NS record
	 -CNAME
	 -MX

	All in a single dialog
*/
PUBLIC void DNS::editone(const char *name)
{
	FQHOST fq (name);
	SSTRING full;
	fq.formatfull(full);
	PRIMARY *pri = primarys.getitem(fq,NULL);
	if (pri == NULL){
		xconf_error (MSG_U(E_HOSTNODOM
			,"Host %s is not part of any domain\n"
			 "managed by this DNS"),full.get());
	}else{
		IPMAPS maps;
		IP_ADDRS adrs;
		primarys.getalladr (adrs);
		maps.setuse (adrs);
		DIALOG dia;
		dia.newf_str (MSG_U(F_HOST_DOM,"host or sub-domain"),full);
		SSTRINGS tbns;
		pri->getns(full,tbns);
		while (tbns.getnb()<3) tbns.add (new SSTRING);
		SSTRINGS tbmx;
		pri->getmx(full,tbmx);
		while (tbmx.getnb()<3) tbmx.add (new SSTRING);
		IP_ADDRS tba;
		pri->geta(full,tba);
		while (tba.getnb()<4) tba.add (new IP_ADDR);
		SSTRING cname;
		pri->getcname (full,cname);
		dia.newf_str (MSG_U(F_NICKNAME,"is a nick name for"),cname);
		int i;
		dia.newf_title ("",MSG_U(F_IPADRS,"IP addresses"));
		for (i=0; i<tba.getnb(); i++){
			FIELD_COMBO *comb = dia.newf_combo ("",*(tba.getitem(i)));
			maps.setcombo(comb);
		}
		dia.newf_title ("",MSG_U(F_DNSADV,"DNS advertising"));
		for (i=0; i<tbns.getnb(); i++){
			dia.newf_str ("",*(tbns.getitem(i)));
		}
		dia.newf_title ("",MSG_U(F_EMAILADV,"EMAIL advertising"));
		for (i=0; i<tbmx.getnb(); i++){
			dia.newf_str ("",*(tbmx.getitem(i)));
		}
		int nofield = 0;
		while (1){
			MENU_STATUS code = dia.edit(MSG_U(T_HOSTINFO,"Host information")
				,MSG_U(I_HOSTINFO,"Enter a host name + domain\n"
				 "and its IP numbers (at least one)\n"
				 "and all DNS's table will be updated\n")
				,help_dnsedit
				,nofield
				,MENUBUT_ACCEPT|MENUBUT_CANCEL|MENUBUT_DEL);
			if (code == MENU_CANCEL){
				break;
			}else{
				if (code == MENU_DEL){
					if (xconf_yesno(MSG_U(Q_CONFIRM,"Please confirm")
						,MSG_U(I_CONFIRM,"Are you sure you want to\n"
						 "delete this entry")
						,help_dnsedit)
						== MENU_YES){
						tbns.delall();
						tbmx.delall();
						tba.delall();
						cname.setfrom ("");
					}else{
						continue;
					}
				}
				const char *tbip[4];
				int nb = 0;
				for (i=0; i<tba.getnb(); i++){
					SSTRING *a = tba.getitem(i);
					if (!a->is_empty()){
						tbip[nb++] = a->get();
					}
				}
				set (full.get(),tbip,nb);
				setns (full,tbns);
				setmx (full,tbmx);
				setcname (full,cname);
				write();
				break;
			}
		}
	}
}

/*
	Edit the host information (A, PTR, NS and MX records) globally.
*/
PUBLIC void DNS::editrecs(const char *preset)
{
	/* #Specification: dnsconf / host editition
		The user is prompted to enter a host or domain name.
		The system query all configured information about
		this host. All this is displayed in a form. The user
		can correct and add information.
	*/
	while (1){
		SSTRING name (preset);
		DIALOG dia;
		dia.newf_str ("",name);
		if (dia.edit(MSG_U(Q_HOSTNAME,"Host or domain specification")
			,MSG_U(I_HOSTNAME,"Enter the name of a host or the name of a\n"
				 "sub-domain.")
			,help_dnsedit)==MENU_ACCEPT){
			const char *pt = name.get();
			if (pt[0] != '\0'){
				if (strcmp(pt,preset)==0){
					xconf_error (MSG_U(E_MUSTINSERT
						,"Insert a name before\n"
						 "the domain name"));
				}else{
					editone (pt);
				}
			}
		}else{
			break;
		}
	}
}


