#pragma interface
#ifndef DNSCONF_H
#define DNSCONF_H

#include <limits.h>

class TBFILE;
class RECORD_IN_SOA;
class RECORD_IN_NS;
class FQHOST;
class DNS;
class IP_ADDRS;

#ifndef MISC_H
	#include <misc.h>
#endif

class IN_NAME: public SSTRING{
	/*~PROTOBEG~ IN_NAME */
	/*~PROTOEND~ IN_NAME */
};

class IP_ADDR: public SSTRING{
protected:
	int a[4];	// By using int instead of unsigned char
			// we can differentiate network number such as
			// 10.0.0 and 10.0
	/*~PROTOBEG~ IP_ADDR */
public:
	IP_ADDR (const IP_ADDR&adr);
	IP_ADDR (const SSTRING&str);
	IP_ADDR (void);
	int cmp (const IP_ADDR *p);
	void increm (void);
	int is_valid (void);
	void merge (IP_ADDR&partial);
	void reformat (void);
	void reverse (void);
	void setfrom (const char *pt);
	void setrev (char *str);
	void shift (void);
	void shift_right (void);
	/*~PROTOEND~ IP_ADDR */
};

#define MAX_SEARCH_RESOLV	6
class RESOLV{
public:
	SSTRING domain;
	SSTRING search[MAX_SEARCH_RESOLV];
	IP_ADDR servers[3];
	/*~PROTOBEG~ RESOLV */
public:
	RESOLV (void);
private:
	void parse (const char *pt);
public:
	int write (void);
	/*~PROTOEND~ RESOLV */
};



enum RECORD_TYPE{
	RTYPE_COMMENT,
	RTYPE_SOA,
	RTYPE_A,
	RTYPE_PTR,
	RTYPE_NS,
	RTYPE_MX,
	RTYPE_CNAME,
	RTYPE_INCLUDE,
	RTYPE_END_INCLUDE,
	RTYPE_ORIGIN
};

class RECORD: public ARRAY_OBJ{
public:
	RECORD_TYPE id;		// Used by the function is() to identify
				// the type of a record
	SSTRING comment;
	//virtual IP_ADDR *getip()const =0;
	//virtual IN_NAME *getname() const =0;
	virtual void print (FILE *fout) const =0;
	/*~PROTOBEG~ RECORD */
public:
	RECORD (RECORD_TYPE _id);
	int cmp (RECORD *other);
	virtual int cmp_left (const char *);
protected:
	virtual int cmpsame (const RECORD *);
public:
	bool is (RECORD_TYPE _id);
	virtual int set (const RECORD *);
	void setcomment (const char *str);
	virtual void sethostpart (const char *);
	/*~PROTOEND~ RECORD */
};

class RECORD_COMMENT: public RECORD{
	/*~PROTOBEG~ RECORD_COMMENT */
public:
	RECORD_COMMENT (const char *str);
	void print (FILE *fout)const;
	/*~PROTOEND~ RECORD_COMMENT */
};

class RECORD_PARSE;

class RECORD_IN: public RECORD{
protected:
	long ttl;
	char nottl;	// Is there a ttl field
	char ttlstr[20];
	/*~PROTOBEG~ RECORD_IN */
public:
	RECORD_IN (RECORD_TYPE _id);
	RECORD_IN (const RECORD_PARSE&p, RECORD_TYPE _id);
	/*~PROTOEND~ RECORD_IN */
};

class RECORD_IN_A: public RECORD_IN{
public:
	IN_NAME name;
	IP_ADDR addr;
	/*~PROTOBEG~ RECORD_IN_A */
public:
	RECORD_IN_A (const RECORD_PARSE&p);
	RECORD_IN_A (const char *_name, const char *_addr);
protected:
	int cmp_left (const char *str);
public:
	int cmphost (const char *host);
protected:
	int cmpsame (const RECORD *other);
public:
	void print (FILE *fout)const;
	int set (const RECORD *other);
	void sethostpart (const char *hostpart);
	void setip (const char *ip);
	/*~PROTOEND~ RECORD_IN_A */
};
class RECORD_IN_PTR: public RECORD_IN{
	IN_NAME name;
	IN_NAME addr;
	/*~PROTOBEG~ RECORD_IN_PTR */
public:
	RECORD_IN_PTR (const RECORD_PARSE&p);
	RECORD_IN_PTR (const char *iprev,
		 const char *host);
protected:
	int cmp_left (const char *str);
public:
	int cmpip (const char *ip);
protected:
	int cmpsame (const RECORD *other);
public:
	void print (FILE *fout)const;
	int set (const RECORD *other);
	void sethostpart (const char *hostpart);
	/*~PROTOEND~ RECORD_IN_PTR */
};

class RECORDS: public ARRAY{
	/*~PROTOBEG~ RECORDS */
public:
	RECORD *getitem (int no)const;
	int save (TBFILE&tbf)const;
	/*~PROTOEND~ RECORDS */
};

class ORIGIN: public ARRAY_OBJ{
public:
	SSTRING origin;
	RECORDS tbrec;
	/*~PROTOBEG~ ORIGIN */
public:
	ORIGIN (const char *_origin);
	int getalladr (IP_ADDRS&adrs);
	void print (bool save_ori, TBFILE&tbf)const;
	int was_modified (void);
	/*~PROTOEND~ ORIGIN */
};

class ORIGINS: public ARRAY{
	/*~PROTOBEG~ ORIGINS */
public:
	ORIGIN *getitem (int no)const;
private:
	int parseend (char *pt,
		 RECORD_PARSE&p,
		 ORIGIN *ori);
	int parsespecial (const char *key,
		 const char *pt,
		 TBFILE&tbf,
		 ORIGIN *&ori);
public:
	int read (const char *named_dir,
		 const char *fname,
		 const char *first_origin);
	int save (const char *named_dir,
		 const char *fname)const;
	/*~PROTOEND~ ORIGINS */
};

class PRIMARY: public ARRAY_OBJ{
public:
	SSTRING domain;
	SSTRING domainv;	// Use to present the domain
				// to the user, differ from domain
				// only for reverse mapping .. so far
	SSTRING file;
	ORIGINS origins;	// origins->getitem(0) is set by default
				// to the domain.
	char isrev;		// Tell if it is a domain or reverse
				// mapping primary.
	/*~PROTOBEG~ PRIMARY */
public:
	PRIMARY (const char *_domain,
		 const char *_file,
		 const char *named_dir);
	PRIMARY (void);
	void addrec (RECORD *rec);
	int edit (DNS&dns);
	void edithosts (DNS&dns);
	int geta (SSTRING&dom, IP_ADDRS&adrs);
	int geta (SSTRING&dom, RECORDS&recs);
	int getalladr (IP_ADDRS&adrs);
	int getcname (SSTRING&dom, SSTRING&cname);
private:
	RECORD *getfirst (RECORD_TYPE rtype);
public:
	int getmx (SSTRING&dom, RECORDS&recs);
	int getmx (SSTRING&dom, SSTRINGS&strs);
	int getns (SSTRING&dom, RECORDS&recs);
	int getns (SSTRING&dom, SSTRINGS&strs);
protected:
	RECORD_IN_SOA *getsoa (void);
public:
	virtual int is_reverse (void);
	int locate_left (FQHOST&fq,
		 RECORD_TYPE rtype,
		 RECORDS&recs);
	int set (FQHOST&fq, RECORD *new_rec);
	virtual void setfromv (void);
	int unset (RECORD *new_rec);
	void updatesoa (void);
	int was_modified (void);
	int write (FILE *fout, const char *named_dir)const;
	/*~PROTOEND~ PRIMARY */
};

class PRIMARY_REV: public PRIMARY{
public:
	/*~PROTOBEG~ PRIMARY_REV */
public:
	PRIMARY_REV (const char *_domain,
		 const char *_file,
		 const char *named_dir);
	PRIMARY_REV (void);
	int is_reverse (void);
	void setfromv (void);
	/*~PROTOEND~ PRIMARY_REV */
};


class PRIMARYS: public ARRAY{
	/*~PROTOBEG~ PRIMARYS */
public:
	void edit (DNS&dns);
	void editbydom (DNS&dns);
	int getalladr (IP_ADDRS&adrs);
	PRIMARY *getitem (FQHOST&fq,
		 char *hostpart,
		 int dontitself);
	PRIMARY *getitem (FQHOST&fq, char *hostpart);
	PRIMARY *getitem (int no)const;
	virtual PRIMARY *new_PRIMARY (void);
private:
	void setselect (DIALOG&dia);
public:
	int write (FILE *fout, const char *named_dir)const;
	/*~PROTOEND~ PRIMARYS */
};
class PRIMARYS_REV: public PRIMARYS{
	/*~PROTOBEG~ PRIMARYS_REV */
public:
	PRIMARY *new_PRIMARY (void);
	/*~PROTOEND~ PRIMARYS_REV */
};

class SECONDARY: public ARRAY_OBJ{
public:
	SSTRING domain;
	IP_ADDR addr[4];
	SSTRING backup;
	/*~PROTOBEG~ SECONDARY */
public:
	SECONDARY (const char *_domain,
		 const char *_backup,
		 const char **_ip_addr,
		 int nb_ip);
	SECONDARY (void);
	int edit (void);
	void write (FILE *fout, const char *named_dir)const;
	/*~PROTOEND~ SECONDARY */
};

class SECONDARYS: public ARRAY{
	/*~PROTOBEG~ SECONDARYS */
public:
	void edit (DNS&dns);
	SECONDARY *getitem (int no)const;
	void write (FILE *fout,
		 const char *named_dir)const;
	/*~PROTOEND~ SECONDARYS */
};

class CACHEFILE: public ARRAY_OBJ{
public:
	SSTRING domain;
	SSTRING path;
	/*~PROTOBEG~ CACHEFILE */
public:
	CACHEFILE (const char *_domain, const char *_path);
	/*~PROTOEND~ CACHEFILE */
};
class CACHEFILES: public ARRAY{
public:
	/*~PROTOBEG~ CACHEFILES */
public:
	CACHEFILE *getitem (int no);
	/*~PROTOEND~ CACHEFILES */
};

/* #Specification: dnsconf / forwarders / number of
	dnsconf arbitrarily limit the number of forwarders to 5.
*/
#define MAX_FORWARDERS	5

class DNS: public ARRAY_OBJ{
	SSTRING pathcfg;
	CACHEFILES cachefiles;
	PRIMARYS primarys;
	PRIMARYS_REV primarys_rev;
	SECONDARYS secondarys;
	IP_ADDR forwarders[MAX_FORWARDERS];
	int nbforward;
	char slave;
	SSTRING xfernets;
	SSTRING bogusns;
	/*~PROTOBEG~ DNS */
public:
	DNS (void);
	void basiccheck (void);
	void check (void);
	int edit (void);
	void editforwarders (void);
	void editmxs (void);
	void editone (const char *name);
	void editrecs (const char *preset);
	int empty (void);
private:
	void parse (const char *buf,
		 const char *fpath,
		 int noline);
public:
	int set (const char *fqhost,
		 const char *tbip[],
		 int nbip);
	void setcname (const SSTRING&fqhost,
		 const SSTRING&cname);
	void setlocalhost (void);
	int setmx (const SSTRING&fqhost, const SSTRINGS&tbmx);
	int setns (const SSTRING&fqhost, const SSTRINGS&tbns);
	void unset (const char *fqhost);
	void unsetmx (const SSTRING&fqhost);
	void unsetns (const SSTRING&fqhost);
	int was_modified (void);
	int write (void);
	/*~PROTOEND~ DNS */
};
	



#include "dnsconf.p"

#endif

