#include <string.h>
#include <assert.h>
#include <stdlib.h>
#include <ctype.h>
#include "diadef.h"
#include "dialog.h"

static FIELD_RADIO *first;

/* #Specification: dialog / radio field
	A radio field is like a check box, but many fields are
	semanticly related. When you select one, the others are
	unselected. radio field are used to present a set of
	mutually exclusive option.

	It is possible to have a all radio fields unselected.

	Each radio field "edit" the save variable. Each one, when
	selected will set the variable to its own instance value.
	When all fields are unselected, the value 0xff is set.

	Here is an example
	# 
	The checkbox is presented like this

	#
	Enable PPP ( ) at boot time
	           (o) on demand
	           ( ) never 
	#
*/
#
PUBLIC FIELD_RADIO::FIELD_RADIO(
	const char *_prompt,
	char &_var,
	char _instance_val,
	const char *_title)
	: FIELD_CHECK_RADIO (_prompt,_var,_title)
{
	instance_val = _instance_val;
	next = first;
	first = this;
}



PUBLIC FIELD_RADIO::~FIELD_RADIO()
{
	// We remove ourself from the table
	FIELD_RADIO **ptpt = &first;
	while (*ptpt != NULL){
		if (*ptpt == this){
			*ptpt = next;
			break;
		}
		ptpt = &(*ptpt)->next;
	}
}

/*
	Draw only the input part of a field
*/
PUBLIC void FIELD_RADIO::drawtxt (WINDOW *dialog)
{
	drawtxt_check (dialog,'(',')',val==instance_val ? 'o' : ' ');
}

PRIVATE FIELD_RADIO *FIELD_RADIO::locate_key(char *key)
{
	FIELD_RADIO *pt = first;
	while (pt != NULL){
		if (pt->var == var){
			pt->format_htmlkey (key,0);
			break;
		}
		pt = pt->next;
	}
	return pt;
}

PUBLIC void FIELD_RADIO::html_draw (int )
{
	char key[100];
	FIELD_RADIO *original = locate_key (key);
	html_printf ("<tr><td>%s<td>",prompt);
	html_defvar ("radio",key,instance_val,val == instance_val ? "checked" : "");
	html_printf ("\t\t%s\n",title);
	if (original == this){
		html_defvarcur (key,val);
	}
}

PUBLIC int FIELD_RADIO::html_validate(int )
{
	int ret = -1;
	char key[100];
	locate_key (key);
	int oldval_bool = atoi(html_getoldval(key)) == instance_val;
	int val_bool = val == instance_val;
	int newval = atoi(html_getval(key));
fprintf (stderr,"validate radio oldval_bool %d val_bool %d newval %d\n",oldval_bool,val_bool,newval);
	if (val_bool == oldval_bool){
		ret = 0;
		val = newval;
	}
	return ret;
}

PUBLIC void FIELD_RADIO::dokey (
	WINDOW *,
	int key,
	FIELD_MSG &msg)
{
	/* #Specification: dialog / FIELD_MSG / strategy
		The FIELD_MSG object was created to achieve the
		radio button widget. When a radio button is selected
		all other radio button operating on the same variable
		should unset themselves. To achive this, the radio
		button dokey() function loaded the address of the edition
		variable into the msg and loaded the instance value into
		the msg.int_val. It set msg.is_loaded to 1. This tells
		the main dialog edit loop to call processmsg for each
		field, passing to it the msg structure.

		Each field will compare msg.key to whatever it decide
		uniquely identify itself. If there is a match, it will
		process msg.int_val and decide whatever should be done.

		All radio buttons will redraw themselves if needed.

		This mecanism achieve a form of simple broadcast to all
		fields of a dialog.
	*/
	switch (key){
	case ' ':
		msg.is_loaded = 1;
		msg.key = (void*)var;
		if (val == instance_val){
			msg.int_val = 0xff;
		}else{
			msg.int_val = instance_val;
		}
		break;
	}
}

PROTECTED void FIELD_RADIO::processmsg(
	WINDOW *dialog,
	FIELD_MSG &msg,
	int drawok)
{
	if (msg.key == (void*)var){
		int was_on = instance_val == val;
		val = msg.int_val;
		int is_on = instance_val == val;
		if (drawok && was_on != is_on) drawtxt(dialog);
	}
}

/*
	Add a check box field to the dialog.
*/
PUBLIC FIELD_RADIO *DIALOG::newf_radio(
	const char *prompt,
	char &var,
	char instance_val,
	const char *title)
{
	FIELD_RADIO *s = new FIELD_RADIO(prompt,var,instance_val,title);
	add (s);
	return s;
}

