#include "dialog.h"
	
/*
	Display a dialog box for inputing a string
	Returne MENU_ACCEPT or MENU_CANCEL or MENU_ESCAPE.
*/
MENU_STATUS dialog_inputbox(
	const char *title,
	const char *prompt,
	HELP_FILE &helpfile,
	char inpstr[MAX_LEN+1])
{
	DIALOG dia;
	inpstr[0] = '\0';
	dia.newf_str ("",inpstr,MAX_LEN);
	return dia.edit (title,prompt,helpfile);
}
/*
	Display a dialog box for inputing a password (mangled echo)
	Returne MENU_ACCEPT or MENU_CANCEL or MENU_ESCAPE.
 */
MENU_STATUS dialog_inputpass(
	const char *title,
	const char *prompt,
	HELP_FILE &helpfile,
	char inpstr[MAX_LEN+1])
{
	DIALOG dia;
	SSTRING tmp(inpstr);
	dia.newf_pass ("",tmp);
	MENU_STATUS ret = dia.edit (title,prompt,helpfile);
	tmp.copy (inpstr);
	return ret;
}

#ifdef TEST

int main (int argc, char *argv[])
{
	init_dialog();
	char input[MAX_LEN+1];
	dialog_inputbox ("This is a test",NULL,help_nil,input);
	dialog_inputpass ("This is a test","Please\nenter\na Password"
		,help_nil,input);
	endwin();
	return 0;
}
#endif

