#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "diadef.h"
#include "dialog.h"

/*
	This class is a virtual class.
	This is the building block for combo-type widget. It edit like
	a string, but a hotkey may trigger a helper function which
	may bring a help dialog or a pick list.
	
	This class do the drawing of the little button at the end of
	the string (an arrow in popular GUI toolkit). It intercept the
	hotkey and trigger the assist function (which must be derived).
*/
PUBLIC FIELD_STRING_HELP::FIELD_STRING_HELP(
	const char *_prompt,
	SSTRING &_str)
	: FIELD_SSTRING (_prompt,_str)
{
}

/*
	Draw only the input part of a field
*/
PUBLIC void FIELD_STRING_HELP::drawtxt (WINDOW *dialog)
{
	FIELD_STRING_BASE::drawtxt(dialog);
	// Add the little button
	wattrset(dialog, inputbox_attr);
	wmove(dialog, box.y,box.x+box.width-1);
	waddch (dialog,ACS_DARROW);
}

PUBLIC void FIELD_STRING_HELP::dokey (
	WINDOW *dialog,
	int key,
	FIELD_MSG &msg)
{
	if (key == 24){
		if (!is_readonly()) assist(dialog);
	}else{
		FIELD_SSTRING::dokey(dialog,key,msg);
	}
}

