#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "dialog.h"
#include "dialog.m"

class FIELD_NUM: public FIELD_STRING_BASE{
	double *dblval;
	int    *intval;
	double dbl_backup;
	int int_backup;
	int ishex;
	int nbdecimals;
	/*~PROTOBEG~ FIELD_NUM */
public:
	FIELD_NUM (const char *_prompt,
		 double *_dblval,
		 int *_intval,
		 int _ishex,
		 int _nbdecimals);
protected:
	void dokey (WINDOW *w, int key, FIELD_MSG&msg);
public:
	void html_draw (int nof);
	int post_validate (void);
	void restore (void);
	void save (void);
	/*~PROTOEND~ FIELD_NUM */
};

PUBLIC FIELD_NUM::FIELD_NUM(
	const char *_prompt,
	double *_dblval,
	int *_intval,
	int _ishex,
	int _nbdecimals)
	: FIELD_STRING_BASE (_prompt, _dblval != NULL ? 30 : 10)
{
	ishex = _ishex;
	dbl_backup = 0;
	int_backup = 0;
	dblval = _dblval;
	intval = _intval;
	if (_dblval != NULL){
		dbl_backup = *_dblval;
		int_backup = (int)dbl_backup;
	}else{
		int_backup = *_intval;
	}
	nbdecimals = _nbdecimals;
	if (_nbdecimals == 0){
		sprintf (buf, _ishex ? "%x" : "%d",int_backup);
	}else{
		sprintf (buf, "%.*f",nbdecimals,dbl_backup);
	}
}

PROTECTED  void FIELD_NUM::dokey(WINDOW *w, int key, FIELD_MSG &msg)
{
	int charok = ishex ? isxdigit(key) : isdigit(key);
	if (charok
		|| (key >= KEY_MIN && key <= KEY_MAX)
		|| key < ' '
		|| (x.input + x.scroll == 0 && key == '-')
		|| (nbdecimals > 0 && key == '.')){
		FIELD_STRING_BASE::dokey(w,key,msg);
	}
}
	
/*
	Draw the field with the prompt
*/
PUBLIC void FIELD_NUM::html_draw(int nof)
{
	char key[100];
	format_htmlkey (key,nof);
	html_printf ("<tr><td>%s<td>",prompt);
	html_defvar ("integer",key,buf,"size=10 maxlength=20");
	html_defvarcur (key,buf);
}



PUBLIC void FIELD_NUM::save()
{
	if (dblval != NULL){
		sscanf (buf,"%lf",dblval);
	}else{
		sscanf (buf,ishex ? "%x" : "%d" ,intval);
	}
}

PUBLIC void FIELD_NUM::restore()
{
	if (dblval != NULL){
		*dblval = dbl_backup;
	}else{
		*intval = int_backup;
	}
}
PUBLIC int FIELD_NUM::post_validate()
{
	int ret = 0;
	const char *pt = buf;
	if (*pt == '-') pt++;
	while (*pt != '\0'){
		if (*pt == '.'){
			if (nbdecimals == 0){
				xconf_error (MSG_U(E_NOPT
					,"No decimal point allowed"));
				ret = -1;
				break;
			}
		}else if (!isdigit(*pt)){
			xconf_error (MSG_U(E_NONDIGIT
				,"Only digits and the minus sign are allowed"));
			ret = -1;
			break;
		}
		pt++;
	}
	return ret;
}



/*
	Add a numerical field to the dialog.
*/
PUBLIC FIELD *DIALOG::newf_num(
	const char *prompt,
	int &val)
{
	FIELD_NUM *s = new FIELD_NUM(prompt,NULL,&val,0,0);
	add (s);
	return s;
}
/*
	Add a hexadecimal field to the dialog.
*/
PUBLIC FIELD *DIALOG::newf_hexnum(
	const char *prompt,
	int &val)
{
	FIELD_NUM *s = new FIELD_NUM(prompt,NULL,&val,1,0);
	add (s);
	return s;
}

/*
	Add a floating point field to the dialog.
*/
PUBLIC FIELD *DIALOG::newf_dbl(
	const char *prompt,
	double &val,
	int nbdecimals)
{
	FIELD_NUM *s = new FIELD_NUM(prompt,&val,NULL,0,nbdecimals);
	add (s);
	return s;
}

