#define __DIALOG_MAIN__

#include <unistd.h>
#include "diadef.h"
#include "dialog.h"
#include "dialog.m"
#ifdef HAVE_NCURSES
	#include "colors.h"
#endif

static char is_init = 0;
/*
	Clean up at the end of the program.
	Called automaticly by atexit().
*/
void dialog_end ()
{
	if (is_init){
		endwin();
		is_init = 0;
	}
}


/*
 * Do some initialization for dialog
 */
void init_dialog(void)
{
	if (dialog_mode == DIALOG_CURSES
		&& !is_init){
		if (!isatty(0)){
			/* #Specification: curse mode / no tty available
				If handle 0 is not a tty, linuxconf will print an error
				message and quit. It will try to print it trying the
				following list

				#
					Message sent to handle 2 if it is a tty.
					Message sent to handle 1 if it is a tty.
					Message sent to /dev/console if it can be opened.
					Message sent to /dev/tty1 if it can be opened.
				#
			*/
			FILE *fout = isatty(2) ? fdopen (2,"w") : (FILE*)NULL;
			if (fout == NULL) fout = isatty(1) ? fdopen (1,"w") : (FILE*)NULL;
			if (fout == NULL) fout = file_exist("/dev/console") ? fopen ("/dev/console","w") : (FILE*)NULL;
			if (fout == NULL) fout = file_exist("/dev/tty1") ? fopen ("/dev/tty1","w") : (FILE*)NULL;
			if (fout != NULL){
				fprintf (fout,"%s\n",MSG_U(E_NOTTY,"**** No tty available ... linuxconf quitting"));
			}
			exit (-1);
		}else{
			static char atexit_init = 0;
			is_init = 1;
			if (!atexit_init){
				atexit (dialog_end);
				atexit_init = 1;
			}
			#ifdef HAVE_NCURSES
			if (parse_rc() == -1)    /* Read the configuration file */
				exit(-1);
			#endif

			initscr();     /* Init curses */
			keypad(stdscr, TRUE);
			cbreak();
			noecho();

			#ifdef HAVE_NCURSES
				if (use_colors || use_shadow)    /* Set up colors */
					color_setup();
			#endif

			/* Set screen to screen attribute */
			attr_clear(stdscr, LINES, COLS, screen_attr);
			wnoutrefresh(stdscr);
		}
	}
}


#ifdef HAVE_NCURSES
/*
 * Setup for color display
 */
void color_setup(void)
{
	if (has_colors()) {    /* Terminal supports color? */
		start_color();

		// Initialize color pairs
		int i;
		for (i = 0; i < ATTRIBUTE_COUNT; i++)
			init_pair(i+1, color_table[i][0], color_table[i][1]);

		// Setup color attributes
		for (i = 0; i < ATTRIBUTE_COUNT; i++)
			attributes[i] = C_ATTR(color_table[i][2], i+1);
	}
}
/* End of color_setup() */
#endif


/*
 * Set window to attribute 'attr'
 */
void attr_clear(WINDOW *win, int height, int width, chtype attr)
{
	if (dialog_mode != DIALOG_CURSES) return;

	wattrset(win, attr);    /* Set window to attribute 'attr' */
	for (int i = 0; i < height; i++) {
		wmove(win, i, 0);
		for (int j = 0; j < width; j++)
			waddch(win, ' ');
	}
	touchwin(win);
}

/*
 * Print a button
 */
void print_button(WINDOW *win, const char *label, int y, int x, int selected)
{
	draw_box(win, y-1, x, 3, strlen(label)+2, dialog_attr
		, border_attr, border_attr_shadow);
	wmove(win, y, x+1);
	int temp = strspn(label, " ");
	label += temp;
	wattrset(win, selected ? button_label_active_attr : button_label_inactive_attr);
	for (int i = 0; i < temp; i++) waddch(win, ' ');
	wattrset(win, selected ? button_key_active_attr : button_key_inactive_attr);
	waddch(win, label[0]);
	wattrset(win, selected ? button_label_active_attr : button_label_inactive_attr);
	waddstr(win, (char*)(label+1));
	wmove(win, y, x+temp+1);
}
/* End of print_button() */


/*
 * Draw a rectangular box with line drawing characters
 */
void draw_box(
	WINDOW *win,
	int y,
	int x,
	int height,
	int width,
	chtype box,
	chtype border_light,	// Receiving the light source
	chtype border_shadow)	
{
	wattrset(win, 0);
	for (int i = 0; i < height; i++) {
		wmove(win, y + i, x);
		for (int j = 0; j < width; j++){
			if (!i && !j)
				waddch(win, border_light | ACS_ULCORNER);
			else if (i == height-1 && !j)
				waddch(win, border_light | ACS_LLCORNER);
			else if (!i && j == width-1)
				waddch(win, border_shadow | ACS_URCORNER);
			else if (i == height-1 && j == width-1)
				waddch(win, border_shadow | ACS_LRCORNER);
			else if (!i)
				waddch(win, border_light | ACS_HLINE);
			else if (i == height-1)
				waddch(win, border_shadow | ACS_HLINE);
			else if (!j)
				waddch(win, border_light | ACS_VLINE);
			else if (j == width-1)
				waddch(win, border_shadow | ACS_VLINE);
			else
				waddch(win, box | ' ');
		}
	}
}
/* End of draw_box() */


/*
 * Draw shadows along the right and bottom edge to give a more 3D look
 * to the boxes
 */
#if defined(HAVE_NCURSES) && 0
void draw_shadow(WINDOW *win, int y, int x, int height, int width)
{
	if (use_shadow
		&& has_colors()) {    /* Whether terminal supports color? */
		wattrset(win, shadow_attr);
		int bottomy = y + height;
		// This code does not work anymore and crash on ELF systems
		// Don't know why yet! The winch() macro seg fault. With this
		// patch, it works and look not so bad
		#define my_winch(w)	' '
		if (bottomy < LINES){
			wmove(win, bottomy, x + 4);
			for (int i = 0; i < width; i++)
				waddch(win, my_winch(win) & A_CHARTEXT);
		}else{
			bottomy = LINES - 1;
		}
		int lastx = x + width;
		if (lastx < COLS){
			for (int i = y + 2; i <= bottomy; i++) {
				wmove(win, i, lastx);
				waddch(win, my_winch(win) & A_CHARTEXT);
				waddch(win, my_winch(win) & A_CHARTEXT);
			}
		}
		#undef my_winch
		wnoutrefresh(win);
	}
}
#else
void draw_shadow(WINDOW *, int, int, int , int)
{
}
#endif
