#include <string.h>
#include <stdlib.h>
#include "diadef.h"
#include <ctype.h>
#include "dialog.h"

PUBLIC FIELD_CHECK_RADIO::FIELD_CHECK_RADIO(
	const char *_prompt,
	char &_var,
	const char *_title)
	: FIELD (_prompt)
{
	title = strdup(_title);
	var = &_var;
	val = _var;
	backup = val;
	box.width = 4 + strlen(_title);
}

PUBLIC FIELD_CHECK_RADIO::~FIELD_CHECK_RADIO()
{
	free (title);
}
PUBLIC void FIELD_CHECK_RADIO::restore()
{
	*var = backup;
}
PUBLIC void FIELD_CHECK_RADIO::save()
{
	*var = val;
}

/*
	Position the cursor in the field
*/
PUBLIC void FIELD_CHECK_RADIO::setcursor(WINDOW *dialog)
{
	wmove (dialog,box.y,box.x+1);
}

/*
	Draw only the input part of a field
*/
PUBLIC void FIELD_CHECK_RADIO::drawtxt_check (
	WINDOW *dialog,
	char openchar,		// Code to draw the left side of the button
	char closechar,		// Right side
	char selchar)		// Interior of the button
{
	wattrset(dialog, inputbox_attr);
	wmove(dialog, box.y,box.x);
	char buf[80];
	int len = sprintf (buf,"%c%c%c %s",openchar,selchar,closechar,title);
	waddstr (dialog,buf);
	for (int i=len; i<box.width; i++) waddch (dialog,' ');
}

/*
	Build a key that uniquely identify this field in the dialog
*/
PUBLIC void FIELD_CHECK_RADIO::format_htmlkey(char *key, int nof)
{
	char buf[200];
	strcpy (buf,prompt);
	strcat (buf,title);
	html_formatkey (key,"%s-%d",buf,nof);
}


/* #Specification: dialog / checkbox
	A checkbox is used to toggle an option. It edit a variable
	from 0 to 1.

	The checkbox is presented like this

	#
	prompt [ ] some explanation
	prompt [X] some explanation
	#
*/
#
PUBLIC FIELD_CHECK::FIELD_CHECK(
	const char *_prompt,
	char &_var,
	const char *_title)
	: FIELD_CHECK_RADIO (_prompt,_var,_title)
{
}


/*
	Draw only the input part of a field
*/
PUBLIC void FIELD_CHECK::drawtxt (
	WINDOW *dialog)
{
	drawtxt_check (dialog,'[',']',val ? 'X' : ' ');
}

static const char YES[]="yes";
static const char NO[]="no";

PUBLIC void FIELD_CHECK::html_draw(int nof)
{
	char key[100];
	format_htmlkey (key,nof);
	html_printf ("<tr><td>%s<td>",prompt);
	html_defvar ("checkbox",key,YES,val ? "checked" : "");
	html_printf ("%s\n",title);
	html_defvarcur (key,val ? YES : NO);
}

PUBLIC int FIELD_CHECK::html_validate(int nof)
{
	int ret = -1;
	char key[100];
	format_htmlkey (key,nof);
	char oldval = stricmp(html_getoldval(key),YES)==0;
	char newval = stricmp(html_getval(key),YES)==0;
fprintf (stderr,"validate chk oldval %d val %d newval %d\n",oldval,val,newval);
	if (val == oldval){
		ret = 0;
		val = newval;
	}
	return ret;
}

PUBLIC void FIELD_CHECK::dokey (
	WINDOW *dialog,
	int key,
	FIELD_MSG &)
{
	switch (key){
	case ' ':
		val = !val;
		drawtxt (dialog);
		break;
	}
}

/*
	Add a check box field to the dialog.
*/
PUBLIC FIELD_CHECK *DIALOG::newf_chk(
	const char *prompt,
	char &var,
	const char *title)
{
	FIELD_CHECK *s = new FIELD_CHECK(prompt,var,title);
	add (s);
	return s;
}

/* #Specification: dialog / checkbox multi
	A checkbox multi is used to toggle an between more than one option
	but not too many. It edit a variable from 0,1,number of option-1.

	It is presented like this.

	#
	prompt (o) opt1 ( ) opt2 ( ) opt3
	prompt ( ) opt1 ( ) opt2 ( ) opt3
	#
*/
#
PUBLIC FIELD_CHECK_MULTI::FIELD_CHECK_MULTI(
	const char *_prompt,
	char &_var,
	const char *_options[])
	: FIELD(_prompt)
{
	var = &_var;
	val = _var;
	backup = val;
	int len = 0;
	for (int i=0; _options[i] != NULL; i++){
		const char *str = _options[i];
		len += strlen(str)+4+1;
		options.add (new SSTRING (str));
	}
	box.width = len;
}


/*
	Draw only the input part of a field
*/
PUBLIC void FIELD_CHECK_MULTI::drawtxt (
	WINDOW *dialog)
{
	char tmp[100];
	int n = options.getnb();
	char *pt = tmp;
	int i;
	for (i=0; i<n; i++){
		pt += sprintf (pt,"(%c) %s "
			,val == i ? 'o' : ' '
			,options.getitem(i)->get());
	}
	wattrset(dialog, inputbox_attr);
	wmove(dialog, box.y,box.x);
	waddstr (dialog,tmp);
	for (i=strlen(tmp); i<box.width; i++) waddch (dialog,' ');
}
PUBLIC void FIELD_CHECK_MULTI::save( )
{
	*var = val;
}
PUBLIC void FIELD_CHECK_MULTI::restore( )
{
	*var = backup;
}

PUBLIC void FIELD_CHECK_MULTI::html_draw(int nof)
{
	char key[100];
	format_htmlkey (key,nof);
	html_printf ("<tr><td>%s<td>",prompt);
	int n = options.getnb();
	for (int i=0; i<n; i++){
		const char *str = options.getitem(i)->get();
		html_defvar ("radio",key,i,val == i ? "checked" : "");
		html_printf ("\t\t%s\n",str);
	}
	html_defvarcur (key,val);
}

PUBLIC int FIELD_CHECK_MULTI::html_validate(int nof)
{
	int ret = -1;
	char key[100];
	format_htmlkey (key,nof);
	int oldval = atoi(html_getoldval(key));
	int newval = atoi(html_getval(key));
	if (val == oldval){
		ret = 0;
		val = newval;
	}
	return ret;
}

PUBLIC void FIELD_CHECK_MULTI::dokey (
	WINDOW *dialog,
	int key,
	FIELD_MSG &)
{
	int nbopt = options.getnb();
	char lastopt = (char)(nbopt-1);
	char newval = val;
	switch (key){
	case ' ':
	case KEY_RIGHT:
		newval = (val+1) % nbopt;
		break;
	case KEY_HOME:
		newval = 0;
		break;
	case 5:		/* ^E like Emacs */
	case KEY_END:
		newval = lastopt;
		break;
	case KEY_LEFT:
		if (newval == 0){
			newval = lastopt;
		}else{
			newval--;
		}
		break;
	}
	if (newval != val){
		val = newval;
		drawtxt (dialog);
	}

}

/*
	Add a check box field to the dialog.
*/
PUBLIC FIELD_CHECK_MULTI *DIALOG::newf_chkm(
	const char *prompt,
	char &var,
	const char *title[])
{
	FIELD_CHECK_MULTI *s = new FIELD_CHECK_MULTI(prompt,var,title);
	add (s);
	return s;
}

