# Help.tcl
# Copyright (c) 1997 Mark Black
# Version 0.1
# By Mark Black

proc help { topic } {
    if { [winfo exists .help ] != 0 } {
	.help.t delete 0.0 end
    } else {
	toplevel .help -class Dialog
	wm title .help "Help"	
	wm iconname .help Dialog
	button .help.quit -text "-Close-" -command { destroy .help }
	pack .help.quit -fill x 
	text .help.t -width 70 -height 16 -yscrollcommand {.help.tscroll set }
	scrollbar .help.tscroll -orient vertical -command ".help.t yview"
	pack .help.tscroll -side left -fill y
	pack .help.t -fill both -expand 1
    }
    if {[winfo depth .help ] > 1} {
	set bold "-foreground #2020f0 " 
	set normal "-foreground #4040a0 "
    } else {
	set bold "-foreground white -background black"
	set normal "-foreground {} -background {}"
    }
    .help.t configure -font -*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-* -wrap word
    .help.t tag configure courier -font -Adobe-Courier-Medium-R-Normal--*-120-*-*-*-*-*-* 
    .help.t tag configure big -font -*-Helvetica-Bold-R-Normal--*-140-*-*-*-*-*-*
    .help.t tag configure red -font -*-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-* -foreground #f02020
    .help.t tag configure blue -font -*-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-* -foreground #2020f0
    .help.t tag configure green -font -*-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-* -foreground #20a020
    .help.t tag configure bigCenter -font -*-Helvetica-Bold-R-Normal--*-140-*-*-*-*-*-* -justify center
    .help.t tag configure title -font -*-Helvetica-Bold-R-Normal--*-180-*-*-*-*-*-* -justify center
    if { $topic == "help" } {
	.help.t insert end "MAT Help Index\n" title
	.help.t insert end "Use the mouse to select from the topics below.  Click on the topic of your choice.\n"
	.help.t insert end "  About MAT, Mark's Administration Tool.\n" t10
	.help.t insert end "  Startup     - How to initially add hosts\n" t15
	.help.t insert end "  Login       - How to login to a MAT agent & change the MAT password.\n" t17
	.help.t insert end "  Users       - Adding, deleting or modifing user accounts.\n" t20
	.help.t insert end "  Groups      - Modify groups and group members.\n" t30
	.help.t insert end "  Hosts       - Adding, deleting and modifing host IP's.\n" t40
	.help.t insert end "  Mail Lists  - Create mailing lists, & redirect mail.\n" t70
	.help.t insert end "  Motd        - Create and edit the login message.\n" t80
	.help.t insert end "  DNS client  - Configure DNS client.\n" t60
	.help.t insert end "  Mounts      - Add or modify mounted filesystems.\n" t50
	.help.t insert end "  Cron        - Add or modify Crontab entries.\n" t90
	.help.t insert end "-----  Work in Progress  ------\n"
	.help.t insert end "DNS  - Create and maintain a DNS server\n"
	.help.t insert end "NIS  - Maint a NIS servers databases\n" 
	.help.t insert end "NFS  - Control a NFS server.\n"
	.help.t insert end "TAPE - Distributed backup and restore.\n"
	foreach tag {t10 t15 t17 t20 t30 t40 t50 t60 t70 t80 t90 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t10 <1> { help mat }
	.help.t tag bind t15 <1> { help startup }
	.help.t tag bind t17 <1> { help matpass }
	.help.t tag bind t20 <1> { help users }
	.help.t tag bind t30 <1> { help groups }
	.help.t tag bind t40 <1> { help hosts }
	.help.t tag bind t50 <1> { help files }
	.help.t tag bind t60 <1> { help dnsc }
	.help.t tag bind t70 <1> { help mail }
	.help.t tag bind t80 <1> { help motd }
	.help.t tag bind t90 <1> { help cronedit }
    } elseif { $topic == "mat" } {
	.help.t insert end "MAT, Mark's Administration Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "Version 0.1 (Beta)\n" bigCenter
	.help.t insert end "By Mark Black  (sblack@ee.ryerson.ca)\n\n" bigCenter
	.help.t insert end "MAT is a networked UNIX administration and monitoring tool.\n" big
	.help.t insert end "It allows you as an administrator, or authorized individual, to change the UNIX configuration, "
	.help.t insert end "of your workstation or a remote machine.  Currently the tool will allow you to change the following files:\n"
	.help.t insert end "    passwd\n"
	.help.t insert end "    group\n"
	.help.t insert end "    hosts\n"
	.help.t insert end "    motd\n"
	.help.t insert end "    resolv.conf\n"
	.help.t insert end "    aliases\n"
	.help.t insert end "    fstab\n"
	.help.t insert end "    crontab\n"
	.help.t insert end "The management module runs on any operating system with Tcl/TK, and the TCP/IP protocol stack installed, "
	.help.t insert end "this includes Win95.  "
	.help.t insert end "Additional modules will be added in the future to support DNS, NIS, NFS, Archiving as well as other OS's.  "
	.help.t insert end "Solaris and SunOS will probably be the next supported OS's\n\n"
	.help.t insert end "Licensing & Warrenty\n" big
	.help.t insert end "The licensing is straightforward.  "
	.help.t insert end "Monitoring and Administration Tool (MAT) is provided AS IS.  Use it at your own risk.  This is an "
	.help.t insert end "ALPHA" red 
	.help.t insert end " release, as such we make NO gaurentee as to the"
	.help.t insert end " softwares fitness for the intended task.  This software is provided free of charge, as such we accept NO liability for lost "
	.help.t insert end "data, time, or any other type of loss.  You by accepting or running part or all of the MAT software programs accept all "
	.help.t insert end "responsibility for any consiquences of it's use."
	.help.t insert end "\n\n"
	.help.t insert end "This software may be freely distributed provided it is complete, and unaltered.  This code cannot be modified for sale."
	.help.t insert end "\n\n"
	.help.t insert end "Security updates, and gereral patches, will be provided for the ALPHA releases.  They will be provided as the MAT source code "
	.help.t insert end "matures.  Their installation or use is subject to this license agreement."

	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "users" } {
	.help.t insert end "User Administration Tool\n" title
	.help.t insert end "<-- Back\n" t10
	.help.t insert end "The Used Administration Tool is used to add, or modify users.  It is designed to provide a simple tool for non-UNIX "
	.help.t insert end "guru to use.  Deleting users is done from the first GUI.  "
	.help.t insert end "The tool can modify any parameter associated with "
	.help.t insert end "a user in the password file.  This section will deal with all of the functions provided by the tool, such as:\n"
	.help.t insert end "  Adding a new user\n" t20
	.help.t insert end "  Modifing a users login\n" t30
	.help.t insert end "  Modifing a users primary group\n" t40
	.help.t insert end "  Modifing a users descriptor (comment)\n" t50
	.help.t insert end "  Changing a users password\n" t60
	.help.t insert end "  Moving a user to a new directory\n" t70
	.help.t insert end "  Changing a users ID number\n" t80
	.help.t insert end "  Changing a users shell\n" t90
	.help.t insert end "\n"
	set pos1 [ .help.t index end ]
	.help.t insert end "Adding a new user\n" bigCenter
	.help.t insert end "The tool is designed to be as simple as possible, as such it makes some simple decisions about "
	.help.t insert end "a users default information.  The tool will create the user with a predetermined "
	.help.t insert end "password, shell, home directory, unless an alternate selection is provided.  The users ID number will be selected "
	.help.t insert end "as the next available number above 1000, unless one is provided.\n\n"
	.help.t insert end "To add a new user go to the "
	.help.t insert end "User Editor.\n" big
	.help.t insert end "This can be reached by first selecting: Users from the Browse menu, or by pressing the Users button.  " 
	.help.t insert end "Double-click the host you want to add the user to.  The default is localhost, that is, this machine.  A "
	.help.t insert end "list of all the users currently on the machine will be displayed.  Press the "
	.help.t insert end "New " green
	.help.t insert end "button.\n  Once in the User Editor you need to provide some basic information about the "
	.help.t insert end "user you are about to add, such as First Name, and Surname.  The Enter, or Return key can be used to "
	.help.t insert end "move down the netry boxes.  The First Name, and Surname fields are combined to form the comment in the "
	.help.t insert end "password file.  Pressing Return in the Surname field will move you to the Login field, were a default "
	.help.t insert end "login has been made from the first letter of the users name, followed by up to 7 characters from the "
	.help.t insert end "users surname.  If the default login is unacceptable it can be edited.\n"
	.help.t insert end "The users primary group has to be selected from the list provided.  User scrollbar to see the rest "
	.help.t insert end "of the groups.  Select the primary group of the new user by clicking on the group.\n"
	.help.t insert end "By default the tool will assume the following:\n"
	.help.t insert end "    Initial password is:  Password\n"
	.help.t insert end "    Initial shell is:  /bin/sh\n "
	.help.t insert end "    Home directory is:  /home/{Users Login}\n"
	.help.t insert end "    User ID number is:  next free UID > 1000\n"
	.help.t insert end "Pressing the Options button opens a window were the above options can be changed.  If the options are "
	.help.t insert end "changed press "
	.help.t insert end "OK " red
	.help.t insert end "to apply the changes to the default options.\n"
	.help.t insert end "Once the data has been entered, and any options changed applied, the user can be created.  Pressing the "
	.help.t insert end "Apply " red
	.help.t insert end "button will attempt to add the user.  To cancel adding a user press the "
	.help.t insert end "Cancel " blue
	.help.t insert end "button.  Once the "
	.help.t insert end "Apply " red
	.help.t insert end "button is pressed, the Command Output window will appear.  The Command Output displays the status of the "
	.help.t insert end "command e.g:\n\n"
	.help.t insert end "MAT agent started on localhost\n" courier
	.help.t insert end "Authentication Passed\n" courier
	.help.t insert end "Attempting to add: John Smith,  Login: jsmith,  Home: /home/jsmith  UID=  Shell: /bin/sh\n" courier
	.help.t insert end "Using 1011 for the users id\n" courier
	.help.t insert end "Adding User: John Smith,  Login: jsmith,  Home: /home/jsmith  UID=1011  Shell: /bin/sh\n" courier
	.help.t insert end "\n"
	.help.t insert end "MAT will create the directory with the appropriate group and ownership.\n"
	.help.t insert end "Default configuration files will be copied from the MATdefaults directory to the new users directory.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos2 [ .help.t index end ]
	.help.t insert end "Modifying a Users Login\n" bigCenter
	.help.t insert end "To modify a user you must first select Users from the Browse menu, or press the Users button.  Then "
	.help.t insert end "Double-click on the host where you want to modify the user.  The default is localhost, that is, this machine. "
	.help.t insert end "A list of all the users will be displayed.  Double-click on the user you wish to modify, or select the users name "
	.help.t insert end "and press the Modify Selected button.  The User Editor will appear.  Type in the new login name and press the "
	.help.t insert end "Apply " red
	.help.t insert end "button.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos3 [ .help.t index end ]
	.help.t insert end "Modifying a Users Primary Group\n" bigCenter
	.help.t insert end "To modify a user you must first select Users from the Browse menu, or press the Users button.  Then "
	.help.t insert end "Double-click on the host where you want to modify the user.  The default is localhost, that is, this machine. "
	.help.t insert end "A list of all the users will be displayed.  Double-click on the user you wish to modify, or select the users name "
	.help.t insert end "and press the Modify Selected button.  The User Editor will appear.  Select the new primary group form the list.\n"
	.help.t insert end "NOTE:" big
	.help.t insert end "Only groups from the /etc/group file will be displayed.  NIS groups are not yet implimented.\n"
	.help.t insert end "After selecting the new group press the "
	.help.t insert end "Apply " red
	.help.t insert end "button.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos4 [ .help.t index end ]
	.help.t insert end "Modifying a Users Descriptor\n" bigCenter
	.help.t insert end "To modify a user you must first select Users from the Browse menu, or press the Users button.  Then "
	.help.t insert end "Double-click on the host where you want to modify the user.  The default is localhost, that is, this machine. "
	.help.t insert end "A list of all the users will be displayed.  Double-click on the user you wish to modify, or select the users name "
	.help.t insert end "and press the Modify Selected button.  The User Editor will appear.\n"
	.help.t insert end "NOTE:" big
	.help.t insert end "The users descriptor (comment) is made by appending the Surname entry to the Firstname entry\n"
	.help.t insert end "To change the descriptor type in a new Firstname, and Surname.  Other information can be included in the comment, "
	.help.t insert end "such as phone number, or location.  This can be done by placing the full name in the Firstname entry field, and "
	.help.t insert end "using the Surname field for any other information.\n"
	.help.t insert end "After entering the new information press the "
	.help.t insert end "Apply " red
	.help.t insert end "button.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos5 [ .help.t index end ]
	.help.t insert end "Changing a Users Password\n" bigCenter
	.help.t insert end "To change a users password you have to go to the options window, by pressing the "
	.help.t insert end "Options " green
	.help.t insert end "button from the User Editor.  To open the User Editor Double-click on the host where you want to modify the user.  "
	.help.t insert end "Then Double-click on the user who's password you want to change.  From the Options window type in the new password "
	.help.t insert end "in the Password field.  Press Return, or Enter to move the the Confirm field.  Type in the new password again in the "
	.help.t insert end "Confirm field.  Press the "
	.help.t insert end "OK " red
	.help.t insert end "button, and then press the "
	.help.t insert end "Apply " red
	.help.t insert end "button to update the password.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos6 [ .help.t index end ]
	.help.t insert end "Changing a Users Home Directory\n" bigCenter
	.help.t insert end "To change a users Home Directory you have to go to the options window, by pressing the "
	.help.t insert end "Options " green
	.help.t insert end "button from the User Editor.  To open the User Editor Double-click on the host where you want to modify the user.  "
	.help.t insert end "Then Double-click on the user who's home location you want to change.  From the Options window click on the Home Dir, "
	.help.t insert end "and type in the new home directory location.  Press the "
	.help.t insert end "OK " red
	.help.t insert end "button, and then press the "
	.help.t insert end "Apply " red
	.help.t insert end "button to update the users home directory.  If possible all files in the users old home directory will be moved to "
	.help.t insert end "the new home directory. \n"
	.help.t insert end "NOTE: " big
	.help.t insert end "This operation can take several minutes to complete!  Ownership and groups of the files in the users directory is "
	.help.t insert end "preserved.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos7 [ .help.t index end ]
	.help.t insert end "Changing a Users ID Number (UID)\n" bigCenter
	.help.t insert end "To change a users ID Number you have to go to the options window, by pressing the "
	.help.t insert end "Options " green
	.help.t insert end "button from the User Editor.  To open the User Editor Double-click on the host where you want to modify the user.  "
	.help.t insert end "Then Double-click on the user who's UID you want to change.  From the Options window click on Select in the UID options.  "
	.help.t insert end "Type in the new UID in the entry field beside the Select button. Press the "
	.help.t insert end "OK " red
	.help.t insert end "button, and then press the "
	.help.t insert end "Apply " red
	.help.t insert end "button to update the UID.  If possible all files in the users home directory will be updated to the new UID.  "
	.help.t insert end "This functionallity is supplied for completeness.  Under most cases it should never be needed.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos8 [ .help.t index end ]
	.help.t insert end "Changing a Users Shell\n" bigCenter
	.help.t insert end "To change a users Shell you have to go to the options window, by pressing the "
	.help.t insert end "Options " green
	.help.t insert end "button from the User Editor.  To open the User Editor Double-click on the host where you want to modify the user.  "
	.help.t insert end "Then Double-click on the user who's shell you want to change.  From the Options window click on the desired shell in "
	.help.t insert end "the Shell frame.   Press the "
	.help.t insert end "OK " red
	.help.t insert end "button, and then press the "
	.help.t insert end "Apply " red
	.help.t insert end "button to update the users shell.\n"
	.help.t insert end "NOTE: " big
	.help.t insert end "Only the shells listed in the /etc/shells file on the host will be displayed.  If you are using other shells you will "
	.help.t insert end "need to update this file (/etc/shells).\n"
	.help.t insert end "<--Top\n" toTop

	foreach tag {toTop t10 t20 t30 t40 t50 t60 t70 t80 t90 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind toTop <1> ".help.t see 0.0 "
	.help.t tag bind t10 <1> { help help }
	.help.t tag bind t20 <1> ".help.t see $pos1 "
	.help.t tag bind t30 <1> ".help.t see $pos2 "
	.help.t tag bind t40 <1> ".help.t see $pos3 "
	.help.t tag bind t50 <1> ".help.t see $pos4 "
	.help.t tag bind t60 <1> ".help.t see $pos5 "
	.help.t tag bind t70 <1> ".help.t see $pos6 "
	.help.t tag bind t80 <1> ".help.t see $pos7 "
	.help.t tag bind t90 <1> ".help.t see $pos8 "
    } elseif { $topic == "groups" } {
	.help.t insert end "Groups Administration Tool\n" title
	.help.t insert end "<-- Back\n" t10
	.help.t insert end "The group administration tool allows you to add, or modify groups.  It provides an easy to use interface for "
	.help.t insert end "editing group membership.  This section will cover:\n"
	.help.t insert end "    What are groups for.\n" t20
	.help.t insert end "    Adding a new group.\n" t30
	.help.t insert end "    Changing group members.\n" t40
	.help.t insert end "    Changing group name, or ID.\n" t50
	.help.t insert end "    Deleting groups.\n" t60
	.help.t insert end "\n"
	set pos1 [ .help.t index end ]
	.help.t insert end "What are groups for?\n" bigCenter
	.help.t insert end "Groups provide a means of controlling access to sensitive areas of your computing environment.  Consider the "
	.help.t insert end "following example.  Widgets Inc have a Development and Administration section which both share the same server.  " 
	.help.t insert end "The primary group for everyone is widget.  A users primary group is controlled from the User Editor.  The Development "
	.help.t insert end "department has some sensitive information, which everyone in development needa access too, but which is too "
	.help.t insert end "dangerous for the Administration department.  To protect the data you can make a secondary group called devel, in "
	.help.t insert end "which you would include all those from the development department.  Any sensitive files or directories should have "
	.help.t insert end "group permission bits set to allow only those in the correct group access.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos2 [ .help.t index end ]
	.help.t insert end "Adding a new group.\n" bigCenter
	.help.t insert end "Adding a new group is a simple procedure.  The tool is designed to be as simple as possible.  To add a new group go to the "
	.help.t insert end "Group Editor.\n" big
	.help.t insert end "This can be reached by first selecting: Groups from the Browse menu, or by Double-clicking on the Groups icon.  " 
	.help.t insert end "Double-click the host you want to add the group to to see the Groups icon.  Press the "
	.help.t insert end "New " green
	.help.t insert end "button.\n  Once in the Group Editor you need to provide some basic information about the group.\n"
	.help.t insert end "In the Group entry box type the name of the group you want to create.  The group name should not exist on the system "
	.help.t insert end "already.  The group name should be kept short, no more than 8 characters.\n"
	.help.t insert end "In the GID# box type in the group identification number.  This is a unique number from 100 to 65535.  Numbers below "
	.help.t insert end "100 are possible, but NOT recommended for new groups, because the system uses some of these.  For this field just pick "
	.help.t insert end "any unused GID number.  The main GUI lists all of the GID's currently in use\n"
	.help.t insert end "If there are any users to add to the new group, type in the users login name in the Add box, and press the Add button.  "
	.help.t insert end "To create the new group press the "
	.help.t insert end "Apply " red
	.help.t insert end "button.  The command output window will display the results of the operation e.g. \n"
	.help.t insert end "MAT agent started on darkstar\n" courier
	.help.t insert end "Authentication Passed\n" courier
	.help.t insert end "File updated\n" courier
	.help.t insert end "The new group is now added.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos3 [ .help.t index end ]
	.help.t insert end "Changing Group Members\n" bigCenter
	.help.t insert end "Changing group members is done from within the Group Editor for secondary groups, and from within the User Editor for " 
	.help.t insert end "primary groups. "
	.help.t insert end "To modify secondary group members you must first select Groups from the Browse menu, or press the Groups button.  Then "
	.help.t insert end "Double-click on the host where you want to modify the group.  The default is localhost, that is, this machine. "
	.help.t insert end "A list of all the groups will be displayed.  Double-click on the group you wish to modify, or select the group "
	.help.t insert end "and press the Modify Selected button.  The Group Editor will appear.  \nTo add a new group member type in the users "
	.help.t insert end "login name in the Add box, and press the Add button.  \nTo delete a user from a group follow the above procedure, but "
	.help.t insert end "this time select the users login from the member list and press the "
	.help.t insert end "Delete " red
	.help.t insert end "button.\n  To apply the change to the group list press"
	.help.t insert end "Apply " red
	.help.t insert end "button, or to abort the changes press the "
	.help.t insert end "Cancel " blue
	.help.t insert end "button.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos4 [ .help.t index end ]
	.help.t insert end "Changing a Group Name or ID number\n" bigCenter
	.help.t insert end "Changing a group is done from within the Group Editor.  " 
	.help.t insert end "To modify a group you must first select Groups from the Browse menu, or Double-click the Groups icon.  To see the "
	.help.t insert end "Groups icon Double-click on the host where you want to modify the group.  The default is localhost, that is, this machine.\n"
	.help.t insert end "A list of all the groups will be displayed.  Double-click on the group you wish to modify, or select the group "
	.help.t insert end "and press the Modify Selected button.  The Group Editor will appear.  " 
	.help.t insert end "If you want to change the group name type in the new name in the Group box, and then press the "
	.help.t insert end "Apply " red
	.help.t insert end "button. \n"
	.help.t insert end "NOTE: " big
	.help.t insert end "Changing the group identification number (GID) is NOT recommended ever!  However it can be done by tyyping in the "
	.help.t insert end "new GID number and pressing the "
	.help.t insert end "Apply " red
	.help.t insert end "button.  All files and directorys using this GID will be affected.  The group for the files and directories will "
	.help.t insert end "no longer be recognized.\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	set pos5 [ .help.t index end ]
	.help.t insert end "Deleting Groups\n" bigCenter
	.help.t insert end "Deleting groups is done from the main GUI.  "
	.help.t insert end "To delete a you must first select Groups from the Browse menu, or Double-click the Groups icon.  The "
	.help.t insert end "Groups icon is visable after Double-click on the host where you want to delete the group."
	.help.t insert end "A list of all the groups will be displayed.  Select the group "
	.help.t insert end "and press the Delete Selected button.  The group will then be deleted.  Use with care!\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop

	foreach tag {toTop t10 t20 t30 t40 t50 t60 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind toTop <1> ".help.t see 0.0 "
	.help.t tag bind t10 <1> { help help }
	.help.t tag bind t20 <1> ".help.t see $pos1 "
	.help.t tag bind t30 <1> ".help.t see $pos2 "
	.help.t tag bind t40 <1> ".help.t see $pos3 "
	.help.t tag bind t50 <1> ".help.t see $pos4 "
	.help.t tag bind t60 <1> ".help.t see $pos5 "
    } elseif { $topic == "hosts" } {
	.help.t insert end "Host Administration Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "A host is any PC, workstation, or device on your TCP/IP network.  Each host one the network must have a unique "
	.help.t insert end "Internet Protocol (IP) address."
	.help.t insert end "This window is for adding/modifing entries in the /etc/hosts file.  This file is consulted when no name service is running.\n\n"
	.help.t insert end "NOTE:  Do NOT use an arbitary IP address.  If you are connected to the Internet you will conflict with Internet IP addresses."
	.help.t insert end "  Several IP address ranges have reserved for private networks, such as 192.168.1.0 to 192.168.1.255.  If you have not been"
	.help.t insert end " assigned an IP address, use one of these.\n\n"
	.help.t insert end "At a minimum you need to provide two pieces of information:  The IP address of the host, and the name of the host. \n\n"
	.help.t insert end "IP Address:\n" big
	.help.t insert end "           The IP address of a host.  The IP address\n"
	.help.t insert end "           is the numeric address of the machine, \n"
	.help.t insert end "           expressed as four dot seperated numbers,\n"
	.help.t insert end "           ranging from 0 to 255 e.g.  123.45.67.89\n"
	.help.t insert end "           Use IP addresses that are valid for your\n"
	.help.t insert end "           network.\n\n"
	.help.t insert end "Host Name:" big
	.help.t insert end "
            The name of the host associated 
            with the IP address.\n\n"
	.help.t insert end "Alias(es):" big
	.help.t insert end "
            Any other names the host may be 
            known as, e.g.  www, or ftp.\n\n"
	.help.t insert end "Adding a new host.\n" bigCenter
	.help.t insert end "Under most conditions it is not necessary to add new hosts to a hosts file.  They are only needed when no "
	.help.t insert end "name service, such as DNS, or NIS(+), is running."
	.help.t insert end "Adding a new host is a simple procedure.  To add a new host go to the "
	.help.t insert end "Host Editor.\n" big
	.help.t insert end "This can be reached by first selecting: Hosts from the Browse menu, or by Double-clicking on the Hosts icon.  " 
	.help.t insert end "Double-click the host you want to add the host to to see the Hosts icon.  Press the "
	.help.t insert end "New " green
	.help.t insert end "button.\nOnce in the Hosts Editor you need to provide some basic information about the host.  "
	.help.t insert end "Type in the IP address of the host in the address field.  Typing the \".\" will move cursor to the next field.  "
	.help.t insert end "Type in the name of the host in the name field.  If the machine has any other names, such as a WWW or FTP server, "
	.help.t insert end "type them in the Alias(es) field.  Press the "
	.help.t insert end "Apply " red
	.help.t insert end "button.  The command result window will display the result of the command.\n\n"
	.help.t insert end "Changing a Host name, alias, or IP\n" bigCenter
	.help.t insert end "Changing a host is done from within the Host Editor.  " 
	.help.t insert end "To modify a host you must first select Hosts from the Browse menu, or Double-click the Hosts icon.  To see the "
	.help.t insert end "Hosts icon Double-click on the host where you want to modify the host.  The default is localhost, that is, this machine."
	.help.t insert end "A list of all the hosts will be displayed.  Double-click on the host you wish to modify, or select the host "
	.help.t insert end "and press the Modify Selected button.  The Host Editor will appear.  " 
	.help.t insert end "Edit the field you want to change, and then press the "
	.help.t insert end "Apply " red
	.help.t insert end "button.  The command result window will display the result of the command.\n\n"
	.help.t insert end "Deleting Hosts\n" bigCenter
	.help.t insert end "Deleting hostss is done from the main GUI.  "
	.help.t insert end "To delete a you must first select Hosts from the Browse menu, or Double-click the Hosts icon.  The "
	.help.t insert end "Hosts icon is visable after Double-click on the host where you want to delete the host."
	.help.t insert end "A list of all the hosts will be displayed.  Select the host "
	.help.t insert end "and press the Delete Selected button.  The host's entry will then be deleted.  Use with care!\n"
	.help.t insert end "\n"
	.help.t insert end "<--Top\n" toTop
	foreach tag {toTop t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind toTop <1> ".help.t see 0.0 "
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "mail" } {
	.help.t insert end "Email Administration Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "The email tool is used to create mailing lists, and to redirect email.  Mailing lists are handy for sending email "
	.help.t insert end "to groups within your organization, for example to might create a mail list for all those in the Admin department, "
	.help.t insert end "called 'admin'.  Sending an email to 'admin' would send the email to all those in the 'admin' mailing list.  "
	.help.t insert end "The tool also allows you to redirect email to one or more other recipients.  This is useful for short mailing lists, "
	.help.t insert end "or to send the email to another location.  This can also be used to give a person the appearence of multiple email "
	.help.t insert end "names, for example the user John Smith, might have a login of 'john', yet receive email addressed to 'jsmith', or "
	.help.t insert end "'john.smith'.  By default every users login is their email name, this can be used to change it, or even stop the user "
	.help.t insert end "from receiving email.\n\n"
	.help.t insert end "Mail Alias: " big
	.help.t insert end "This is the name of the email list, or the email address to redirect from.  Users will send email to this name.  Type "
	.help.t insert end "in the name for the mail alias.\n\n"
	.help.t insert end "Alias Type: " big
	.help.t insert end "Select the type of email alias you wish to create.  List, is used to create a mailing list.  Redirect, is used to "
	.help.t insert end "send the email to another email address(s).  Once you select the alias type the window will change accordingly. \n\n"
	.help.t insert end "For redirected emial you will be asked for:\n"
	.help.t insert end "Email address to redirect to: " big
	.help.t insert end "This is one or more, comma seperated, email addresses.  It can contain external emails, of the form name@location, or "
	.help.t insert end "internal email addresses of the form 'login_name', or even the names of mailing lists.\n\n"
	.help.t insert end "For email lists you will be asked for:\n"
	.help.t insert end "List File: " big
	.help.t insert end "This is the name of the file containing the mailing list.\n\n"
	.help.t insert end "To add entries to the list type the email address in the entry box and press the "
 	.help.t insert end "Add " big
	.help.t insert end "button.  To remove an entry from the list use the scrollbar to scroll to the desired entry, and right click on the "
	.help.t insert end "entry and press the "
	.help.t insert end "Delete " red
	.help.t insert end "button.\n"
	.help.t insert end "After all the changes have been applied press the "
	.help.t insert end "Apply " red
	.help.t insert end "button.  This will update the mail aliases, and if necessary write the mailing list.\n"
	.help.t insert end "\n"

	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "files" } {
	.help.t insert end "Filesystem Administration Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "This window is for adding/modifing mounted 
filesystems.  A variety of filesystems are 
supported.  You must provide the following 
information:\n
Type:         Click the button corresponding to the 
              type of filesystem you wish to mount.
              Note:  The kernel MUST be compiled to 
              support the type of filesystem you
              want to mount.\n
Device:       This is the name of the local device
              which contains the filesystem you 
              want to mount.\n
NFS Server:   The name, or IP, of the NFS server.\n
Remote Filesystem:  The name of the filesystem 
              exported (shared) from the server.\n
Mount Point:  The location on the machine to 
              mount (graft) the filesystem to.  
              Mount points are directories.  If 
              the directory does not exist it 
              will be created.\n
Type:         Only NFS filesystems are supported
              in this version.\n
Options:      These are the mounting options.  
              See the man pages for details."

	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "dnsc" } {
	.help.t insert end "DNS Client Administration Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "All machines on the Internet rely on the Domain Name Service (DNS) to provide hostname to IP address mappings.  "
	.help.t insert end "DNS is a database of the hosts on the Internet, which is distributed accross thousands DNS servers.  To use DNS "
	.help.t insert end "a machine must be told about the DNS domain it is part off.  It must be told the address of at least one DNS server, "
	.help.t insert end "and the domain to which it belongs.\n\n"
	.help.t insert end "In the domain field type the name of the domain to which the host belongs e.g.  stimpy.org\n\n"
	.help.t insert end "In the DNS servers field type the IP number of your DNS server, and press the "
	.help.t insert end "Add" big
	.help.t insert end " button.\n\n"
	
	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "cronedit" } {
	.help.t insert end "Crontab Editing Tool\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "Cron allows you to run programs at scheduled times.  Cron is useful for routine administrative tasks, such as backups.  "
	.help.t insert end "This tool allows you to easily modify and add cron jobs.   There are two basic requirements for a cron job namely the "
	.help.t insert end "job, script, or program to run, and a schedule for running it.\n\n"
	.help.t insert end "In the Process: field type the name of the program, or script, you would like to run.  Remember to put in any redirects "
	.help.t insert end "if you need them e.g.  To not see stderr add 2>/dev/null to the end of the process field.  Any jobs which produce an "
	.help.t insert end "output to stdout, or stderr will produce an email message for root, so it is sometimes desirable to redirect stdout with "
	.help.t insert end "1>/dev/null.\n\n"
	.help.t insert end "You can place an optional comment in the Comment field.  \n\n" 
	.help.t insert end "The minute, and hour fields control the time of day to run the process.  The process may be run several times during the day.  "
	.help.t insert end "For example setting the minutes to 30, and the hours to 8,20 will cause the process to be run at 8:30am, and 8:30pm.  "
	.help.t insert end "Likewise setting setting the minutes 15,45, and the hours to Any will cause the process to be run 48 times a day at "
	.help.t insert end "15 and 45 minutes past each hour.  \nClicking on the "
	.help.t insert end "Minutes: " big
	.help.t insert end "button provides a list of choices, or you can enter the minutes in the entry box at the side, in a comma seperated list.  \n"
	.help.t insert end "Clicking on the "
	.help.t insert end "Hours: " big
	.help.t insert end "button provides a list of all the hour choices, or you can enter the hours in the entry box at the side, in a comma "
	.help.t insert end "seperated list.  Selecting Any will cause the process to run on the selected day every hour when the minutes match the " 
	.help.t insert end "current time minutes.  \n"
	.help.t insert end "The next three buttons are for selecting the day to run the process.  The process will run when the Week day is satisfied, OR " 
	.help.t insert end "the combination of Month Day, and Month.  For example selecting Monday for the Week Day, and 15 for the Month Day, and Any "
	.help.t insert end "Month, would allow the process to run every Monday, and every 15th of the month.\n\n"
	.help.t insert end "After providing the information press the "
	.help.t insert end "Apply" red
	.help.t insert end " button.  The information is transfered to the host, and the process will run at the scheduled time."
	
	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "matpass" } {
	.help.t insert end "MAT Login and Passwords\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "Sorry, no help is available on DNS client configuration in this version.\n"
	.help.t insert end "Look for updated help in the next revision."

	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } elseif { $topic == "startup" } {
	.help.t insert end "MAT Startup\n" title
	.help.t insert end "<-- Back\n" t1
	.help.t insert end "Thank you for trying MAT. \n"
	.help.t insert end "\n"
	.help.t insert end "To start you need to add the hosts to the MAT hosts file.  Select "
	.help.t insert end "Agent" big
	.help.t insert end " and in the menu choose: "
	.help.t insert end "MAT Hosts" big
	.help.t insert end ".  At the bottom of the screen click the "
	.help.t insert end "NEW" green
	.help.t insert end " button.  A new window will open.  Add the hosts name in the MAT Host field, and select the services which the "
	.help.t insert end "host provides.\n"
	.help.t insert end "Note:" big
	.help.t insert end " This version of MAT does not have full support for the listed services.  The modules for these services are still "
	.help.t insert end "pre-alpha.\n\n"
	.help.t insert end "An icon will appear for the just added host.  Click the "
	.help.t insert end "NEW" green
	.help.t insert end " button to add as many hosts as you like.\n\n"
	.help.t insert end "The default password used by the root account is not secure, and MUST be changed.  Double-click on the hosts icon.  "
	.help.t insert end "Select "
	.help.t insert end "Agent" big
	.help.t insert end " from the top of the window and choose: "
	.help.t insert end "Login" big
	.help.t insert end ".  The login window will appear.  Click on the "
	.help.t insert end "Change Password" red
	.help.t insert end " button.  Do not remove the default password.  Enter the new password twice, and click the "
	.help.t insert end "Okay" green
	.help.t insert end " button.  This new password will be needed to control the MAT agent on that host, so don't loose it.\n"
	.help.t insert end "Enjoy......"
	foreach tag {t1 } {
	    .help.t tag bind $tag <Any-Enter> ".help.t tag configure $tag $bold"
	    .help.t tag bind $tag <Any-Leave> ".help.t tag configure $tag $normal"
	    .help.t tag configure $tag -foreground #4040a0
	}
	.help.t tag bind t1 <1> { help help }
    } else {
	.help.t insert end "Sorry\n" title
	.help.t insert end "No help is available on the selected item.  Look for improved help in the next release.\n"
	.help.t insert end "\n"
	.help.t insert end "Go to Main Menu\n" t10
	.help.t tag bind t10 <Any-Enter> ".help.t tag configure t10 $bold"
	.help.t tag bind t10 <Any-Leave> ".help.t tag configure t10 $normal"
	.help.t tag configure t10 -foreground #4040a0
	.help.t tag bind t10 <1> { help help }
    }
}



