# Cron.tcl
#
# Copyright (c) 1997 Mark Black
# Alpha release

#
# CronEdit  - Edit a crontab entry
#
# USE: CronEdit CurrentHost CurrentLine SelectedData
#             CurrentHost = host to update
#             CurrentLine = Line number of selected line
#                           If 9999 then it is a new entry
#             SelectedData = line of data to modify
# NOTE: Data must be seperated by a single space or a singel tab
#
proc CronEdit { currenthost currentline line args } {
    set host $currenthost
    if { [string length $args ] != 0 } {
	append line " $args"
    }
    if { [winfo exists .croned ] == 0 } {
	toplevel .croned -class Dialog
	wm title .croned "Crontab Editor: $currenthost"
	wm iconname .croned "Crontab Editor"
	entry .croned.hidden1 
	entry .croned.hidden2
	entry .croned.hidden3
	# NOT GOOD
	.croned.hidden1 insert end $currenthost
	.croned.hidden2 insert end $currentline
	.croned.hidden3 insert end $line
	frame .croned.f1 -bd 2 -relief "raised"
	label .croned.f1.l1 -text "Process:" -width 12
	entry .croned.f1.e1 -width 32
	pack .croned.f1.l1 .croned.f1.e1 -fill x -side left -expand 1
	frame .croned.f2 -bd 2 -relief "raised"
	label .croned.f2.l1 -text "Comment:" -width 12
	entry .croned.f2.e1 -width 32
	pack .croned.f2.l1 .croned.f2.e1 -fill x -side left -expand 1

	frame .croned.f3 -bd 2 -relief "raised"
	menubutton .croned.f3.l1 -text "Minutes:" -width 12 -menu .croned.f3.l1.m -relief raised
	menu .croned.f3.l1.m -tearoff 0 
	for { set cnt 0 } { $cnt < 61 } { incr cnt 5 } {
	    .croned.f3.l1.m add command -label $cnt -command ".croned.f3.e1 insert end \"$cnt,\" "
	}
	entry .croned.f3.e1 -width 32
	pack .croned.f3.l1 .croned.f3.e1 -fill x -side left -expand 1 -pady 4

	frame .croned.f4 -bd 2 -relief "raised"
#	menubutton .croned.f4.l1 -text "Hours:" -width 12 -direction below -menu .croned.f4.l1.m -relief raised
	menubutton .croned.f4.l1 -text "Hours:" -width 12 -menu .croned.f4.l1.m -relief raised
	menu .croned.f4.l1.m -tearoff 0 
	set hours {{1} {2} {3} {4} {5} {6} {7} {8} {9} {10} {11} {12} {13} {14} {15} {16} {17} {18} {19} {20} {21} {22} {23} {Any}}
	for { set cnt 0 } { $cnt < 24 } { incr cnt 1 } {
	    .croned.f4.l1.m add command -label [lindex $hours $cnt] -command ".croned.f4.e1 insert end \"[lindex $hours $cnt],\" "
	}
	entry .croned.f4.e1 -width 32
	pack .croned.f4.l1 .croned.f4.e1 -fill x -side left -expand 1 -pady 4

	frame .croned.f5 -bd 2 -relief "raised"
#	menubutton .croned.f5.l1 -text "Month Days:" -width 12 -direction below -menu .croned.f5.l1.m -relief raised
	menubutton .croned.f5.l1 -text "Month Days:" -width 12 -menu .croned.f5.l1.m -relief raised
	menu .croned.f5.l1.m -tearoff 0 
	set monthdays {{1} {2} {3} {4} {5} {6} {7} {8} {9} {10} {11} {12} {13} {14} {15} {16} {17} {18} {19} {20} {21} {22} {23} {24} {25} {26} {27} {28} {29} {30} {31} {Any}}
	for { set cnt 0 } { $cnt < 32 } { incr cnt 1 } {
	    .croned.f5.l1.m add command -label [lindex $monthdays $cnt ] -command ".croned.f5.e1 insert end \"[lindex $monthdays $cnt ],\" "
	}
	entry .croned.f5.e1 -width 32
	pack .croned.f5.l1 .croned.f5.e1 -fill x -side left -expand 1 -pady 4

	frame .croned.f6 -bd 2 -relief "raised"
#       menubutton .croned.f6.l1 -text "Month:" -width 12 -direction below -menu .croned.f6.l1.m -relief raised
	menubutton .croned.f6.l1 -text "Month:" -width 12 -menu .croned.f6.l1.m -relief raised
	menu .croned.f6.l1.m -tearoff 0 
	set months {{Jan} {Feb} {Mar} {Apr} {May} {Jun} {Jul} {Sep} {Oct} {Nov} {Dec} {Any}}
	for { set cnt 0 } { $cnt < 12 } { incr cnt 1 } {
	    .croned.f6.l1.m add command -label [lindex $months $cnt ] -command ".croned.f6.e1 insert end \"[lindex $months $cnt ],\" "
	}
	entry .croned.f6.e1 -width 32
	pack .croned.f6.l1 .croned.f6.e1 -fill x -side left -expand 1 -pady 4

	frame .croned.f7 -bd 2 -relief "raised"
#       menubutton .croned.f7.l1 -text "Week Day:" -width 12 -direction below -menu .croned.f7.l1.m -relief raised
	menubutton .croned.f7.l1 -text "Week Day:" -width 12 -menu .croned.f7.l1.m -relief raised
	menu .croned.f7.l1.m -tearoff 0 
	set weekday {{Sun} {Mon} {Tue} {Wed} {Thu} {Fri} {Sat} {Any}}
	for { set cnt 0 } { $cnt < 8 } { incr cnt 1 } {
	    .croned.f7.l1.m add command -label [lindex $weekday $cnt ] -command ".croned.f7.e1 insert end \"[lindex $weekday $cnt ],\" "
	}
	entry .croned.f7.e1 -width 32
	pack .croned.f7.l1 .croned.f7.e1 -fill x -side left -expand 1 -pady 4

	frame .croned.f8 -bd 2 -relief "raised"
	button .croned.f8.b1 -text "Apply" -foreground red -activeforeground #a00000 -command {
	    if { [.croned.f1.e1 get] != "" } {
		# Update the master list
		global master
		set nmin [string trimright [.croned.f3.e1 get ] "," ]
		set nhour [string trimright [.croned.f4.e1 get ] "," ]
		if { $nhour == "Any" } {
		    set nhour {*}
		}
		set nmday [string trimright [.croned.f5.e1 get ] "," ]
		if { $nmday == "Any" } {
		    set nmday {*}
		}
		set nmonth [ month2num [.croned.f6.e1 get ]]
		set nday [ day2num [.croned.f7.e1 get ]]
		set currentline [.croned.hidden2 get]
		if { $currentline != 9999 } {
		    set newcron [ lreplace $master [.croned.hidden2 get] [.croned.hidden2 get] "$nmin $nhour $nmday $nmonth $nday [.croned.f1.e1 get ]" ]
		    # Update comment if needed
		    set tmp2 [expr $currentline - 1 ] 
		    set tmp [ lindex $master $tmp2 ]
		    if { [string range $tmp 0 1 ] == "#v" } {
			set master [ lreplace $newcron $tmp2 $tmp2 "#v [.croned.f2.e1 get ]" ]
		    } else {
			set master $newcron
		    }
		} else {
		    lappend master "#v [.croned.f2.e1 get ]"
		    lappend master "$nmin $nhour $nmday $nmonth $nday [.croned.f1.e1 get ]"
		} 
		set upgrade_buff {}
		set upgrade_buff $master
		set cmd "put local crontab"
		set returnval [queryHost [.croned.hidden1 get ] $cmd 1 "ext" "put" "v" "upgrade_buff" ]
		if { [lindex [split $returnval " " ] 0 ] == "\{ERROR:" } {
		    error 361
		    puts stdout "ERROR:  Unable to upload the crontab to $currenthost"
		} else {
		    # Send the command to update the crontab
		    set cmd "croninstall c"
		    set returnval [queryHost [.croned.hidden1 get ] $cmd 1 ]
		    if { [lindex [split $returnval " " ] 0 ] == "\{ERROR:" } {
			error 362
			puts stdout "ERROR:  Unable to update crontab on $currenthost"
		    } else {
			set returndata [queryHost [.croned.hidden1 get ] "get crontab" 0 ]
			filltext $returndata .general.text 12
			destroy .croned
		    }
		}
	    } else {
		error 360
	    }
	}
	button .croned.f8.b2 -text "Cancel" -foreground blue -activeforeground #000080 -command {
	    set returndata [queryHost [.croned.hidden1 get ] "get crontab" 0 ]
	    filltext $returndata .general.text 12
	    destroy .croned
	}
	button .croned.f8.b3 -text "Help" -foreground #008000 -activeforeground #004000 -command {
	    help cronedit
	}
	pack .croned.f8.b1 .croned.f8.b2 .croned.f8.b3 -side left -fill x 
	

	pack .croned.f1 .croned.f2 .croned.f3 .croned.f4 .croned.f5 .croned.f6 .croned.f7 .croned.f8 -fill both -side top -expand 1
    } else {
	wm title .croned "Crontab Editor: $currenthost"
	.croned.hidden1 delete 0 end
	.croned.hidden2 delete 0 end
	.croned.hidden3 delete 0 end
	.croned.hidden1 insert end $currenthost
	.croned.hidden2 insert end $currentline
	.croned.hidden3 insert end $line
	.croned.f1.e1 delete 0 end
	.croned.f2.e1 delete 0 end
	.croned.f3.e1 delete 0 end
	.croned.f4.e1 delete 0 end
	.croned.f5.e1 delete 0 end
	.croned.f6.e1 delete 0 end
	.croned.f7.e1 delete 0 end
    }
    # ----------- Bindings -------------
    bind .croned.f1.e1 <Return> {
	focus .croned.f2.e1
    }
    bind .croned.f2.e1 <Return> {
	focus .croned.f3.e1
    }
    bind .croned.f3.e1 <Return> {
	focus .croned.f4.e1
    }
    bind .croned.f4.e1 <Return> {
	focus .croned.f5.e1
    }
    bind .croned.f5.e1 <Return> {
	focus .croned.f6.e1
    }
    bind .croned.f6.e1 <Return> {
	focus .croned.f7.e1
    }
    bind .croned.f7.e1 <Return> {
	focus .croned.f1.e1
    }

    # -----------------  Fill Entries ----------------
    if { $currentline != 9999 } {
	# Modify
	.croned.f3.e1 insert end "[ string trim [lindex $line 0 ]],"
	set tmp [ string trim [lindex $line 1 ]]
	if { $tmp == {*} } {
	    .croned.f4.e1 insert end "Any,"
	} else {
	    .croned.f4.e1 insert end "$tmp,"
	}
	set tmp [ string trim [lindex $line 2 ]]
	if { $tmp == {*} } {
	    .croned.f5.e1 insert end "Any,"
	} else {
	    .croned.f5.e1 insert end "$tmp,"
	}
	set tmp [ string trim [lindex $line 3 ]]
	month2day .croned.f6.e1 $tmp
	set tmp [ string trim [lindex $line 4 ]]
	num2day .croned.f7.e1 $tmp
	for { set loc 5 } { $loc < [llength $line] } { incr loc 1 } {
	    .croned.f1.e1 insert end "[string trim [lindex $line $loc ] ] "
	}

	if { $currentline > 0 } {
	    global master
	    set tmp [ lindex $master [expr $currentline - 1 ] ]
	    if { [string range $tmp 0 1 ] == "#v" } {
		.croned.f2.e1 insert end [string range $tmp 3 end]
		set comment 1
	    }
	}
    }
}


#
# Convert the day names to cron numbers
#
proc day2num { data } {
    set output {}
    foreach day [ split $data {,} ] {
	if { $day == "Sun" } {
	    append output "0,"
	} elseif { $day == "Mon" } {
	     append output "1,"
	} elseif { $day == "Tue" } {
	    append output "2,"
	} elseif { $day == "Wed" } {
	    append output "3,"
	} elseif { $day == "Thu" } {
	    append output "4,"
	} elseif { $day == "Fri" } {
	    append output "5,"
	} elseif { $day == "Sat" } {
	    append output "6,"
	} elseif { $day == "Any" } {
	    append output "*,"
	} 
    }
    return [string trimright $output "," ]
}

#
# Convert the month names to cron numbers
#
proc month2num { data } {
    set output {}
    foreach day [ split $data {,} ] {
	if { $day == "Jan" } {
	    append output "1,"
	} elseif { $day == "Feb" } {
	    append output "2,"
	} elseif { $day == "Mar" } {
	    append output "3,"
	} elseif { $day == "Apr" } {
	    append output "4,"
	} elseif { $day == "May" } {
	    append output "5,"
	} elseif { $day == "Jun" } {
	    append output "6,"
	} elseif { $day == "Jul" } {
	    append output "7,"
	} elseif { $day == "Aug" } {
	    append output "8,"
	} elseif { $day == "Sep" } {
	    append output "9,"
	} elseif { $day == "Oct" } {
	    append output "10,"
	} elseif { $day == "Nov" } {
	    append output "11,"
	} elseif { $day == "Dec" } {
	    append output "12,"
	} elseif { $day == "Any" } {
	    append output "*,"
	} 
    }
    return [string trimright $output "," ]
}


#
# Fill an entry box with the day names given the munbers
#
proc num2day { window data } {
    foreach day [ split $data {,} ] {
	if { $day == "0" } {
	    $window insert end "Sun,"
	} elseif { $day == "1" } {
	    $window insert end "Mon,"
	} elseif { $day == "2" } {
	    $window insert end "Tue,"
	} elseif { $day == "3" } {
	    $window insert end "Wed,"
	} elseif { $day == "4" } {
	    $window insert end "Thu,"
	} elseif { $day == "5" } {
	    $window insert end "Fri,"
	} elseif { $day == "6" } {
	    $window insert end "Sat,"
	} elseif { $day == {*} } {
	    $window insert end "Any,"
	} 
    }
}


#
# Fill an entry box with the month names given the munbers
#
proc month2day { window data } {
    foreach day [ split $data {,} ] {
	if { $day == "1" } {
	    $window insert end "Jan,"
	} elseif { $day == "2" } {
	    $window insert end "Feb,"
	} elseif { $day == "3" } {
	    $window insert end "Mar,"
	} elseif { $day == "4" } {
	    $window insert end "Apr,"
	} elseif { $day == "5" } {
	    $window insert end "May,"
	} elseif { $day == "6" } {
	    $window insert end "Jun,"
	} elseif { $day == "7" } {
	    $window insert end "Jul,"
	} elseif { $day == "8" } {
	    $window insert end "Aug,"
	} elseif { $day == "9" } {
	    $window insert end "Sep,"
	} elseif { $day == "10" } {
	    $window insert end "Oct,"
	} elseif { $day == "11" } {
	    $window insert end "Nov,"
	} elseif { $day == "12" } {
	    $window insert end "Dec,"
	} elseif { $day == {*} } {
	    $window insert end "Any,"
	} 
    }
    $window delete end end
}


# CronEdit localhost 23 0 4 * * date




