# Canvas.tcl 
# Copyright (c) 1997 Mark Black
#
# This file contains the routines for populating the canvas widget


#
# -------------------- Procedure for filling the canvas ----------------
#
#  Level = The command/host level
#          10 = Host select canvas
#          20 = Config file select
#          30 = Stat Selector
#          40 = DNS Master
#          50 = MAT User
#          60 = NFS Server
#          70 = NIS Server
proc fillCan { tlevel } {
    if { [winfo exists .tp.host.canvas ] != 0 } {
	destroy .tp.host.canvas
    }
    canvas .tp.host.canvas -yscrollcommand {.tp.host.vscroll set } -scrollregion { 0 0 500 500 } 
    pack .tp.host.canvas -side left -fill both -expand 1
    if { $tlevel == 10 } {
	.tp.title configure -text "Host"
	set hostok [ image create photo -file "../lib/host_ok.gif" ]
	set hostalrm [ image create photo -file "../lib/host_alrm.gif" ]
	set hostsel [ image create photo -file "../lib/host_select.gif" ]
	set hostselalrm [ image create photo -file "../lib/host_select_alrm.gif" ]
	set hostoff [ image create photo -file "../lib/host_off.gif" ]
	global level
	set level 10
	# +++++  Fill canvas with HOST icons  +++++
	global mb_hosts
	global currenthost
	global active_hosts

	set startX 30
	set startY 24
	set icon_size 40
	set incX 70
	set incY 80
	set cntx 0
	foreach line $active_hosts {
	    # The line of data contains numerous fields
	    set hostname [ lindex [split $line ":" ] 0 ]
	    set status [ lindex [split $line ":" ] 4 ]
	    if { $status == 0 } {
		set node [ .tp.host.canvas create image $startX $startY -image $hostoff -tags $hostname ]
	    } else {
		set node [ .tp.host.canvas create image $startX $startY -image $hostok -tags $hostname ]
	    }
	    .tp.host.canvas bind $hostname <Double-1> "set currenthost $hostname ;puts $hostname ;fillCan 20 ;wm title . \"MAT on: $hostname\""
#	    .tp.host.canvas bind $hostname <Button-1> "set currenthost $hostname ; .tp.host.canvas itemconfigure $hostname -image $hostsel"

	    .tp.host.canvas bind $hostname <Button-3> "hostinfo $hostname"
	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text $hostname -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} -tags nameLabel ]
	    # Build a list of all the pertenant data
	    set iconName($node) $hostname
	    set node2nameLabel($node) $nameLabel
	    incr startX $incX
	    incr cntx 1
	    if { $cntx == 8 } {
		set cntx 0
		set startX 30
		incr startY $incY 
	    }
	}
    } elseif { $tlevel == 20 } {
	# +++++  Fill canvas with Configuration icons  +++++
	global currenthost
	global active_hosts
	.tp.title configure -text "Host($currenthost) --> Config"
	set fig(-10) [ image create photo -file "../lib/back40.gif" ]
	set fig(5) [ image create photo -file "../lib/users40.gif" ]
	set fig(2) [ image create photo -file "../lib/groups40.gif" ]
	set fig(1) [ image create photo -file "../lib/hosts40.gif" ]
	set fig(7) [ image create photo -file "../lib/motd40.gif" ]
	set fig(6) [ image create photo -file "../lib/dnsc40.gif" ]
	set fig(8) [ image create photo -file "../lib/alias40.gif" ]
	set fig(3) [ image create photo -file "../lib/fstab40.gif" ]
	set fig(12) [ image create photo -file "../lib/crontab.gif" ]
#	set fig(8) [ image create photo -file "../lib/task.gif" ]
#	set fig(9) [ image create photo -file "../lib/rocket.gif" ]
#	set fig(10) [ image create photo -file "../lib/samba.gif" ]
	set fig(10) [ image create photo -file "../lib/export40.gif" ]
#	set fig(12) [ image create photo -file "../lib/sudo40.gif" ]
	set fig(80) [ image create photo -file "../lib/dnsm40.gif" ]
	set fig(81) [ image create photo -file "../lib/mat.gif" ]
	set fig(82) [ image create photo -file "../lib/tape.gif" ]
	set fig(83) [ image create photo -file "../lib/yp40.gif" ]
	set startX 30
	set startY 24
	set icon_size 40
	set incX 70
	set incY 80
#	set config_label { <-Back Users Groups Hosts Motd DNS_Client Mail Mounts Tasks Inittab Samba Exports Sudoers }
#	set browse_val { -10 5 2 1 7 6 8 3 0 4 9 10 11 }
	set config_label { <-Back Users Groups Hosts Motd DNS_Client Mail Mounts Cron }
	set browse_val { -10 5 2 1 7 6 8 3 12}
	set cnt 0
	set cntx 0
	global level
	set level 20
	global browse
	foreach type $config_label {
	    set btype [ lindex $browse_val $cnt ]
	    set node [ .tp.host.canvas create image $startX $startY -image $fig($btype) -tags $type ]
	    .tp.host.canvas bind $type <Double-1> "set browse $btype ;repack $btype"
	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text [ lindex $config_label $cnt ] -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	    incr startX $incX 
	    incr cnt 1
	    incr cntx 1
	    if { $cntx == 8 } {
		set cntx 0
		set startX 30
		incr startY $incY 
	    }
	}
	# -----------  Special Icon for MAT  -------------------
	set node [ .tp.host.canvas create image $startX $startY -image $fig(81) -tags matu ]
	.tp.host.canvas bind matu <Double-1> "fillCan 50"
	set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "MAT" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	incr startX $incX 
	incr cnt 1
	incr cntx 1
	if { $cntx == 8 } {
	    set cntx 0
	    set startX 30
	    incr startY $incY 
	}
	foreach mathost $active_hosts {
	    if { $currenthost == [ lindex [split $mathost ":" ] 0 ] } {
		set services [ lindex [split $mathost ":" ] 3 ]
		break
	    }
	}
	set HasDNS 0
	set HasNIS 0
	set HasNFS 0
	set HasSAMBA 0
	set HasTAPE 0
	foreach data [split $services "," ] {
	    if { $data == "DNS" } {
		set HasDNS 1
	    } elseif { $data == "NIS" } {
		set HasNIS 1
	    } elseif { $data == "NFS" } {
		set HasNFS 1
	    } elseif { $data == "SAMBA" } {
		set HasSAMBA 1
	    } elseif { $data == "TAPE" } {
		set HasTAPE 1
	    } 
	}
	if { $HasDNS == 1 } {
	    # -----------  Special Icon for DNS  -------------------
	    set node [ .tp.host.canvas create image $startX $startY -image $fig(80) -tags dnsm ]
	    .tp.host.canvas bind dnsm <Double-1> "fillCan 40"
	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "DNS" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	    incr startX $incX 
	    incr cnt 1
	    incr cntx 1
	    if { $cntx == 8 } {
		set cntx 0
		set startX 30
		incr startY $incY 
	    }
	}
	if { $HasNIS == 1 } {
	    # -----------  Special Icon for NIS  -------------------
	    set node [ .tp.host.canvas create image $startX $startY -image $fig(83) -tags nism ]
	    .tp.host.canvas bind nism <Double-1> "fillCan 70"
	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "NIS" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	    incr startX $incX 
	    incr cnt 1
	    incr cntx 1
	    if { $cntx == 8 } {
		set cntx 0
		set startX 30
		incr startY $incY 
	    }
	}
	if { $HasNFS == 1 } {
	    # -----------  Special Icon for NFS  -------------------
	    set node [ .tp.host.canvas create image $startX $startY -image $fig(10) -tags nfs ]
	    .tp.host.canvas bind nfs <Double-1> "fillCan 80"
	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "NFS" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	    incr startX $incX 
	    incr cnt 1
	    incr cntx 1
	    if { $cntx == 8 } {
		set cntx 0
		set startX 30
		incr startY $incY 
	    }
	}
	if { $HasTAPE == 1 } {
	    # -----------  Special Icon for Backup/Restore  -------------------
	    set node [ .tp.host.canvas create image $startX $startY -image $fig(82) -tags bak ]
	    .tp.host.canvas bind bak <Double-1> "fillCan 60"
	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "Archive" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	    incr startX $incX 
	    incr cnt 1
	    incr cntx 1
	    if { $cntx == 8 } {
		set cntx 0
		set startX 30
		incr startY $incY 
	    }
	}
    } elseif { $tlevel == 30 } {
	global currenthost
	.tp.title configure -text "Host($currenthost) --> Config --> Host Stats"
	# Reserved for Stat screens
    } elseif { $tlevel == 40 } { 
	# ---------------  DNS Master Screen  --------------------------
	canDNSM
    } elseif { $tlevel == 60 } {
	# ---------------------  Backup/Restore Window  ---------------------
	canARCHIVE
    } elseif { $tlevel == 50 } {
	# ---------------------  MAT Control Window  ---------------------
	canMAT
    } elseif { $tlevel == 70 } {
	# ---------------------  NIS Server Window  ---------------------
	canNIS
    } elseif { $tlevel == 80 } {
	# ---------------------  NFS Server Window  ---------------------
	canNFS
    } 
}


#
# Build the NIS screen
#
proc canNIS {} {
    # ---------------------  NIS Server Window  ---------------------
    global currenthost
    global level
    set level 70
    global browse
    .tp.title configure -text "Host($currenthost) --> Config --> NIS Server"
    # Reserved for NIS screens
    set fig(-20) [ image create photo -file "../lib/back40.gif" ]
    set fig(70) [ image create photo -file "../lib/users40.gif" ]
    set fig(71) [ image create photo -file "../lib/groups40.gif" ]
    set fig(72) [ image create photo -file "../lib/hosts40.gif" ]
    set fig(23) [ image create photo -file "../lib/alias40.gif" ]
    set fig(24) [ image create photo -file "../lib/dnsc40.gif" ]
    set fig(29) [ image create photo -file "../lib/rocket.gif" ]
    set startX 30
    set startY 24
    set icon_size 40
    set incX 70
    set incY 80
    set cnt 0
    set cntx 0
    set config_label { <-Back Passwd Group Hosts Aliases Netgroup YPmake}
    set browse_val { -20 70 71 72 23 24 29 }
    foreach type $config_label {
	set btype [ lindex $browse_val $cnt ]
	set node [ .tp.host.canvas create image $startX $startY -image $fig($btype) -tags $type ]
	.tp.host.canvas bind $type <Double-1> "set browse $btype ;repack $btype"
	set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text [ lindex $config_label $cnt ] -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	incr startX $incX 
	incr cnt 1
	incr cntx 1
	if { $cntx == 8 } {
	    set cntx 0
	    set startX 30
	    incr startY $incY 
	}
    }

    .tp.host.canvas create text 270 100  -justify center -text "Code not included in this release" -fill red -font {-*-Helvetica-Medium-R-Normal--*-200-*-*-*-*-*-*} 
}


#
# Build the NFS screen
#
proc canNFS {} {
    global currenthost
    global level
    global browse
    set level 80
    .tp.title configure -text "Host($currenthost) --> Config --> NFS Server"
    # Reserved for Export screens
    set fig(0) [ image create photo -file "../lib/back40.gif" ]
    set startX 30
    set startY 24
    set icon_size 40
    set incX 100
    set incY 80
    set cnt 0
    set cntx 0
    set node [ .tp.host.canvas create image $startX $startY -image $fig($cnt) -tags "<-Back" ]
    .tp.host.canvas bind "<-Back" <Double-1> "repack -20"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "<- Back" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
    .tp.host.canvas create text 270 100  -justify center -text "Code not included in this release." -fill red -font {-*-Helvetica-Medium-R-Normal--*-200-*-*-*-*-*-*}
}


#
# Build the MAT Control Window
#
proc canMAT {} {
    global currenthost
    global level
    global browse
    .tp.title configure -text "Host($currenthost) --> Config --> MAT"
    set level 50
    set fig(0) [ image create photo -file "../lib/back40.gif" ]
    set fig(1) [ image create photo -file "../lib/mat_user.gif" ]
    set fig(2) [ image create photo -file "../lib/mat_logs.gif" ]
    set fig(3) [ image create photo -file "../lib/mat_upgrd.gif" ]
    set startX 30
    set startY 24
    set icon_size 40
    set incX 100
    set incY 80
    set cnt 0
    set cntx 0
    set node [ .tp.host.canvas create image $startX $startY -image $fig($cnt) -tags "<-Back" ]
    .tp.host.canvas bind "<-Back" <Double-1> "repack -20"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "<- Back" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*}]
    incr startX 80 
    incr cnt 1
    incr cntx 1
    set node [ .tp.host.canvas create image $startX $startY -image $fig($cnt) -tags "Users" ]
    .tp.host.canvas bind "Users" <Double-1> "set browse 91 ;repack 91"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "MAT Users" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
    incr startX $incX 
    incr cnt 1
    incr cntx 1
    set node [ .tp.host.canvas create image $startX $startY -image $fig($cnt) -tags "Logs" ]
    .tp.host.canvas bind "Logs" <Double-1> "set browse 92 ;repack 92"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "MAT Logs" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
    incr startX $incX 
    incr cnt 1
    incr cntx 1
    set node [ .tp.host.canvas create image $startX $startY -image $fig($cnt) -tags "Upgrade" ]
    .tp.host.canvas bind "Upgrade" <Double-1> "upgrade $currenthost"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "Upgrade MAT" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
    incr startX $incX 
    incr cnt 1
    incr cntx 1
}


#
# Build the Backup/Restore Screen
#
proc canARCHIVE {} {
    global currenthost
    global level
    global browse
    .tp.title configure -text "Host($currenthost) --> Config --> Archives "
    set level 60
    set fig(0) [ image create photo -file "../lib/back40.gif" ]
    set fig(1) [ image create photo -file "../lib/backup.gif" ]
    set fig(2) [ image create photo -file "../lib/restore.gif" ]
    set fig(3) [ image create photo -file "../lib/sched.gif" ]
    set startX 30
    set startY 24
    set icon_size 40
    set incX 100
    set incY 80
    set cnt 0
    set cntx 0
    set node [ .tp.host.canvas create image $startX $startY -image $fig($cnt) -tags "<-Back" ]
    .tp.host.canvas bind "<-Back" <Double-1> "repack -20"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "<- Back" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*}]
    incr startX 80 
    incr cnt 1
    incr cntx 1
    set node [ .tp.host.canvas create image $startX $startY -image $fig($cnt) -tags "Backup" ]
    .tp.host.canvas bind "Backup" <Double-1> "set browse 81 ;repack 81"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "Backup" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
    incr startX $incX 
    incr cnt 1
    incr cntx 1
    set node [ .tp.host.canvas create image $startX $startY -image $fig($cnt) -tags "Restore" ]
    .tp.host.canvas bind "Restore" <Double-1> "set browse 82 ;repack 82"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "Restore" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
    incr startX $incX 
    incr cnt 1
    incr cntx 1
    set node [ .tp.host.canvas create image $startX $startY -image $fig($cnt) -tags "Sched" ]
    .tp.host.canvas bind "Sched" <Double-1> "set browse 83 ;repack 83"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "Backup Schedule" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
    incr startX $incX 
    incr cnt 1
    incr cntx 1
    .tp.host.canvas create text 270 100  -justify center -text "Code not included in this release." -fill red -font {-*-Helvetica-Medium-R-Normal--*-200-*-*-*-*-*-*}
}


#
# Build the DNS Master window
#
proc canDNSM {} {
    global currenthost
    global currentdomain
    global level
    global browse
    .tp.title configure -text "Host($currenthost) --> Config --> DNS Master"
    set level 40
    # Put in back button
    set fig(0) [ image create photo -file "../lib/back40.gif" ]
    set fig(1) [ image create photo -file "../lib/new40.gif" ]
    set fig(2) [ image create photo -file "../lib/hosts40.gif" ]
    set fig(3) [ image create photo -file "../lib/dnssec.gif" ]
    set startX 30
    set startY 24
    set icon_size 40
    set incX 100
    set incY 80
    set cnt 0
    set cntx 0
    set node [ .tp.host.canvas create image $startX $startY -image $fig($cnt) -tags "<-Back" ]
    .tp.host.canvas bind "<-Back" <Double-1> "repack -20"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "<- Back" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
    incr startX 80 
    incr cnt 1
    incr cntx 1
    set node [ .tp.host.canvas create image $startX $startY -image $fig($cnt) -tags "New" ]
    .tp.host.canvas bind "New" <Double-1> "DnsMConfig $currenthost -"
    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "New" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
    incr startX $incX 
    incr cnt 1
    incr cntx 1
    # Draw icons for each domain
    set cmd "DNS get domain"
    set returndata [queryHost $currenthost $cmd 0 ]
    set tmp [ split $returndata ":" ]
    puts stdout $returndata
    if { $returndata != {} } {
	foreach line $tmp {
	    set tmp2 [ split $line "," ] 
	    set type [ lindex $tmp2 0 ]
	    set masterip [ lindex $tmp2 1 ]
	    set domain [ lindex $tmp2 2 ]
	    set node [ .tp.host.canvas create image $startX $startY -image $fig(2) -tags $domain ]
	    .tp.host.canvas bind $domain <Double-1> "set currentdomain $domain ;set browse 41 ;repack 41"
	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "Domain\n$domain" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	    incr startX $incX 
	    incr cnt 1
	    if { $cnt == 6 } {
		set cnt 0
		set startX 30
		incr startY $incY 
	    }
	    # ---------------  Add the Secondaries Icon -----------------
	    set node [ .tp.host.canvas create image $startX $startY -image $fig(3) -tags s$domain ]
	    .tp.host.canvas bind s$domain <Double-1> "set currentdomain $domain ;set browse 42 ;repack 42"
	    set nameLabel [ .tp.host.canvas create text $startX [expr $startY + 0.7 * $icon_size] -justify center -text "Secondaries\n$domain" -tags nameLabel -font {-*-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*} ]
	    incr startX $incX 
	    incr cnt 1
	    if { $cnt == 6 } {
		set cnt 0
		set startX 30
		incr startY $incY 
	    }
	}	
    }
    .tp.host.canvas create text 270 100  -justify center -text "Warning: This is pre-alpha code!" -fill red -font {-*-Helvetica-Medium-R-Normal--*-200-*-*-*-*-*-*}
}













