/*  
    PFlow 2.5: A potential flow demonstrator for fluid dynamics eduation
    Copyright (C) 1998  Craig P. Earls

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//STARTPRETTY
#ifndef PFSTATUS_H
#define PFSTATUS_H 1

#include "qdialog.h"
#include "pfsinglist.hpp"
#include "pfstreamlist.hpp"
#include "pfdatapointlist.hpp"
#include "pfcalcengine.hpp"
#include "pfsingtable.hpp"
#include "pfdatatable.hpp"
#include "pfdatagraph.hpp"

//Implemented as a singleton class.
class QObject;
class QString;

class PFStatus: public QObject
{
Q_OBJECT

public:

  static PFStatus* Instance();

  bool isTAMode();
  bool canShowSingularities();
  bool canShowDataTable();
  bool canShowSingTable();
 
  bool hasName();
  QString getName();
  void setName(QString name);

  SingList *getSingList();
  StreamList *getStreamList();
  DataPointList *getDataPointList();
  CalcEngine *getCalcEngine();
  SingTable *getSingTable();
  DataTable *getDataTable();
  DataGraph *getDataGraph();

  void clear();

public slots:
  QString saveFile();
  QString saveFileAs();
  QString openFile();

protected:
  PFStatus(QObject *parent=0,const char *name=0);

private:
  static PFStatus* d_Instance;
  
  bool d_IsTAMode;
  bool d_CanShowSingularities;
  bool d_canShowDataTable;
  bool d_canShowSingTable;
  
  bool d_HasName;
  QString d_FileName;
  
  CalcEngine *d_Engine; 
  SingList *d_SingularityList;
  StreamList *d_Streamlines;
  DataPointList *d_DataPoints;
  SingTable *d_SingTable;
  DataTable *d_DataTable;
  DataGraph *d_DataGraph;

};
#endif
//ENDPRETTY
/*
 * Local variables:
 *  compile-command: "cd ..;make -k"
 * End:
 */
