/*  
    PFlow 2.5: A potential flow demonstrator for fluid dynamics eduation
    Copyright (C) 1998  Craig P. Earls

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//STARTPRETTY
#include <qobject.h>
#include <qstring.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qbitarray.h>

#include "pfstatus.hpp"

#include "pffiledlg.hpp"
#include "pffileparser.hpp"

//Singleton Creator

PFStatus* PFStatus::d_Instance=0;

PFStatus* PFStatus::Instance(){
  if (d_Instance==0){
    d_Instance=new PFStatus();
  }
  return d_Instance;
}

PFStatus::PFStatus(QObject *parent,const char *name):QObject(parent,name){

  d_IsTAMode=FALSE;
  d_CanShowSingularities=TRUE;
  
  d_HasName=FALSE;
  d_FileName="";

  d_SingularityList = new SingList(this,"singlist");
  d_Streamlines = new StreamList(this,"streamlist");

  d_Engine = new CalcEngine(d_SingularityList,0.02);
  d_DataPoints = new DataPointList(d_Engine,this,"datapointlist");

  d_SingTable = new SingTable(d_SingularityList,0,"SingTable");
  d_DataTable = new DataTable(d_DataPoints,0,"DataTable");
  d_DataGraph = new DataGraph(d_DataPoints,0,"DataTable");


}
  
SingList *PFStatus::getSingList(){
  return d_SingularityList;
};

StreamList *PFStatus::getStreamList(){
  return d_Streamlines;
};

DataPointList *PFStatus::getDataPointList(){
  return d_DataPoints;
};

CalcEngine *PFStatus::getCalcEngine(){
  return d_Engine;
};

SingTable *PFStatus::getSingTable(){
  return d_SingTable;
};

DataTable *PFStatus::getDataTable(){
  return d_DataTable;
};

DataGraph *PFStatus::getDataGraph(){
  return d_DataGraph;
};

bool PFStatus::isTAMode(){
  return d_IsTAMode;
};

bool PFStatus::canShowSingularities(){
  return d_CanShowSingularities;
};
bool PFStatus::hasName(){
  return d_HasName;
};

void PFStatus::setName(QString name){
  d_HasName=TRUE;
  d_FileName=name;
};

QString PFStatus::getName(){
  return d_FileName;
};



QString PFStatus::saveFile(){
    if(hasName() ){
      PFFileParser *parser= new PFFileParser(this);
      QFile *outputFile=new QFile(d_FileName);
      outputFile->open(IO_WriteOnly);
      QTextStream *tstream=new QTextStream(outputFile);
      parser->writeFile(tstream);
      outputFile->close();
      delete tstream;
      delete outputFile;
      return(d_FileName);}
    else{
      saveFileAs();
      return(d_FileName);
    }
};

QString PFStatus::saveFileAs(){
  QString l_name=QFileDialog::getSaveFileName();
  //  QString l_name=PFFileDlg::getSaveFileName();

  if(l_name.length()>0){
    setName(l_name);
    QFile *outputFile=new QFile(d_FileName);

    PFFileParser *parser= new PFFileParser(this);
    outputFile->open(IO_WriteOnly);
    QTextStream *tstream=new QTextStream(outputFile);
    parser->writeFile(tstream);
    delete tstream;
    outputFile->close();
    delete outputFile;
    return(QString("Saved as ") +l_name);
  }
  else{
    return(QString("Save canceled."));
  }
};

QString PFStatus::openFile(){  
  QString l_name=QFileDialog::getOpenFileName();
  //  QBitArray flags=PFFileDlg::getOpenFileFlags(l_name);
  if(l_name.length()>0){
    QFile *inputFile= new QFile(l_name);
    inputFile->open(IO_ReadOnly);
    clear();
    PFFileParser *parser= new PFFileParser(this);
    if(parser->parseFile(inputFile)){
      inputFile->close();
      setName(l_name);
      return(QString("Opened ") +l_name);
    }
    else{
      inputFile->close();
      return(QString("Open Failed!!!"));
    };
  }
  else{
    return(QString("Open canceled."));
  }
  
};
void PFStatus::clear(){
  d_FileName="";
  d_HasName=FALSE;
  
  d_Streamlines->clear();
  d_SingularityList->clear();
  d_DataPoints->clear();
  d_SingTable->clearList();
  d_DataTable->clearList();
 
}
//ENDPRETTY

/*
 * Local variables:
 *  compile-command: "cd ..;make -k"
 * End:
 */
