/*  
    PFlow 2.5: A potential flow demonstrator for fluid dynamics eduation
    Copyright (C) 1998  Craig P. Earls

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//STARTPRETTY


#ifndef PFSINGTABLE_H
#define PFSINGTABLE_H 1

#include <qpoint.h>
#include "pfsinglist.hpp"
#include "QdbtTabular-0.31/src/qdbttabular.h"

//class PFStatus;

class MyTabular : public QdbtTabular
{

Q_OBJECT

public:
  MyTabular(QWidget *parent=0,const char *name=0,WFlags f=0);
  ~MyTabular();

public slots:
  void cellChanged(int row,int col);

signals:
  void NewValue(double Val, int X, int Y);  
  void BadValue(int Row);  
protected:
  void mousePressEvent(QMouseEvent *); 
  
private:
  QPoint currentCell;
};

class SingTable : public QWidget
{

Q_OBJECT

public:
  SingTable(SingList *p_SingularityList,QWidget *parent=0, const char *name=0, WFlags f=0);
  ~SingTable();

  enum {TYPECOLUMN= 0,
	XCOLUMN= 1,
	YCOLUMN= 2,
	MAGCOLUMN= 3,
	ANGCOLUMN=4}; 

public slots:
  void addSingularity(Singularity *Sing);
  void changeSingularity(double Val, int row, int col);
  void correctBadEntry(int row);
  void clearList();
  void updateall();
private:
  int d_NumRows;

  QPixmap *lvort;
  QPixmap *rvort;
  QPixmap *sink;
  QPixmap *source;
  QPixmap *dipole;
  QPixmap *stream;
#ifndef PI
  const double PI=3.1415926535;
#endif//PI
  SingList *d_SingularityList;//SL
  MyTabular *tabular;

  //Methods
  void singToTable(Singularity *Sing,int row);
};

#endif//SINGTABLE
//ENDPRETTY
/*
 * Local variables:
 *  compile-command: "cd ..;make -k"
 * End:
 */
