/*  
    PFlow 2.5: A potential flow demonstrator for fluid dynamics eduation
    Copyright (C) 1998  Craig P. Earls

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//STARTPRETTY


#ifndef PFSINGLIST_H
#define PFSINGLIST_H 1
#include <qlist.h>
#include <qobject.h>

class Singularity
{
public:
  Singularity( float X, float Y, int Type, double Mag, double ang);
  ~Singularity(){};
  enum  {FREESTREAM,SOURCE,SINK,VORTEX,DIPOLE};
  float x;
  float y;
  int t;
  double mag;
  double ang;
};

typedef QListT<Singularity>                    SingListBase;
class SingList:public QObject, public SingListBase{

Q_OBJECT

public:
  SingList( QObject *parent=0, const char *name=0);
  ~SingList(){}; 

  void addNewSingularity(float X, float Y, 
			 int Type, double Mag, double ang,bool update=TRUE);

  void change(int Index, float X, float Y, 
	      int Type, double Mag, double ang);

  double getFreeSpeed();
  void setFreeSpeed(double NewVal);
  double getFreeDirection();
  void setFreeDirection(double NewVal);
signals:
  void NewItemAdded(Singularity *p_Singularity);
  void ListCleared();
  void ListChanged();
  void ItemRemoved(int Index);
public slots:
  void clear();  
  void setFreeStream(double Mag, double Ang);
private:
  double d_FreeSpeed;
  double d_FreeDirection;
};
    
#endif
//ENDPRETTY
/*
 * Local variables:
 *  compile-command: "cd ..;make -k"
 * End:
 */
