/*  
    PFlow 2.5: A potential flow demonstrator for fluid dynamics eduation
    Copyright (C) 1998  Craig P. Earls

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//STARTPRETTY
#ifndef PFFILEPARSER_H
#define PFFILEPARSER_H 1

#include <qobject.h>
#include <qfile.h>
#include <qtextstream.h>
#include "pfstatus.hpp"

class PFFileParser : public QObject
{
  Q_OBJECT                                // required for signals/slots
public:
  PFFileParser( QObject *parent=0, const char *name="" );
  
  bool parseFile(QFile *inputFile);
  bool writeFile(QTextStream *tstream);

private:
  bool parseSource(QString line);
  bool parseDipole(QString line);
  bool parseVortex(QString line);
  bool parseFreeStream(QString line);
  bool parseDataPoint(QString line);
  bool parseStreamline(QString line);

  int floatExtract( QString s, float *fa, int max );

  PFStatus *d_PFStatus;
  SingList *d_SingularityList;
  StreamList *d_Streamlines;
  DataPointList *d_DataPoints;
};
#endif
//ENDPRETTY
/*
 * Local variables:
 *  compile-command: "cd ..;make -k"
 * End:
 */

