/*  
    PFlow 2.5: A potential flow demonstrator for fluid dynamics eduation
    Copyright (C) 1998  Craig P. Earls

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//STARTPRETTY
#ifndef PFDISPLAY_H
#define PFDISPLAY_H 1
//Qt Includes
#include <qframe.h>
#include <qlabel.h>
#include <qsize.h>
#include "Qwtlib-0.2/include/qwt_autoscl.h"
#include "Qwtlib-0.2/include/qwt_scldraw.h"
#include "Qwtlib-0.2/include/qwt_scale.h"
//Custom Includes

#include "pfstatus.hpp"
#include "pfgrid.hpp"

class PFDisplay : public QFrame
{
    Q_OBJECT
public:
  PFDisplay(QWidget *parent=0, const char *name=0);
  void mousePressEvent( QMouseEvent * );
  void resizeEvent(QResizeEvent * );
  void setPressureContourPixmap(QPixmap *p_Contours);
  void print(QPainter *p);


  void setFluidColor(QColor *a);
  void setGridColor(QColor *a);
  void setStreamlineColor(QColor *a);
  void setSingularityColor(QColor *a);
  void setDataPointColor(QColor *a);

protected:
  void paintEvent( QPaintEvent * );

public slots:
  void setStatus(const char *);

  void resetColors();

  void setDisplayGrid(bool p_Flag);
  void setDisplaySingularities(bool p_Flag);
  void setDisplayStreamlines(bool p_Flag);
  void setDisplayDataPoints(bool p_Flag);
  void setDisplaySnapToGrid(bool p_Flag);

signals:
  void LeftClicked(double X, double Y);  
  void RightClicked(double X, double Y);  

private:
 

  QColor *d_FluidColor;
  QColor *d_GridColor;
  QColor *d_StreamlineColor;
  QColor *d_SingColor;
  QColor *d_DataPointColor;

  PFStatus *d_PFStatus;
  SingList *d_Singularities;
  StreamList *d_Streamlines;
  DataPointList *d_DataPoints;

  QLabel *d_Status;
  Grid *d_Gridlines;

  const int axisCnt=4;

  QwtScale *d_Axes[axisCnt]; 
  QwtDiMap d_map[axisCnt];
  QwtAutoScale d_as[axisCnt];
  QwtScaleDiv d_sdiv[axisCnt];

  static const QwtScaleDiv DummyScale;

  bool d_ShowGridFlag;
  bool d_ShowStreamFlag;
  bool d_ShowDataPointsFlag;
  bool d_ShowSingFlag;
  bool d_ShowPressureFlag;
  bool d_ShowDetailsFlag;
  bool d_DrawPressureContours;
  bool d_PressureValid;
  bool d_SnapToGrid;

  double d_XInt,d_YInt;

  void paintStreamLines(QPainter *p);
  void paintVortex(QPainter *p, int X, int Y, double Mag);
  void paintSource(QPainter *p,int X, int Y, double Mag);
  void paintDipole(QPainter *p,int X, int Y, double Ang);
  void paintFreeStream(QPainter *p, double Ang);
  void paintSingularities(QPainter *p);
  void paintDataPoints(QPainter *p);
  void plotStreamLine(QPainter *p,Streamline *s);

  const int GRIDPACK=20;
#ifndef PI
  const double PI=3.1415926535;
#endif
};
#endif // FLUID_H
//ENDPRETTY
/*
 * Local variables:
 *  compile-command: "cd ..;make -k"
 * End:
 */
