/*  
    PFlow 2.5: A potential flow demonstrator for fluid dynamics eduation
    Copyright (C) 1998  Craig P. Earls

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//STARTPRETTY

#ifndef PFDATAPOINTLIST_H
#define PFDATAPOINTLIST_H 1
#include <qlist.h>
#include <qobject.h>

#include "pffpoint.hpp"
#include "pfcalcengine.hpp"

typedef struct {
  FPoint position;
  float uX;
  float uY;
  float pressure;
} DataPoint;


//DataPointList, a list of datapoints
typedef QListT<DataPoint> DataPointListBase;

//You have to inherit from QObject first, or the signals won't get
//passed correctly by the meta compiler.
class DataPointList:public QObject, public DataPointListBase{

  Q_OBJECT

public:
  DataPointList(CalcEngine *, QObject *parent=0, const char *name=0);
 
  void addNewDataPoint(float X, float Y,bool update=TRUE);
  void change(int Index, float X, float Y);
signals:
  void NewItemAdded(DataPoint *dp);
  void ListChanged();
  void Updated();
public slots:
  void update(int);  
  void updateall();
private:
  CalcEngine *d_Engine;
};
#endif
//ENDPRETTY
/*
 * Local variables:
 *  compile-command: "cd ..;make -k"
 * End:
 */
