/*  
    PFlow 2.5: A potential flow demonstrator for fluid dynamics eduation
    Copyright (C) 1998  Craig P. Earls

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
//STARTPRETTY
#include "pfdatapointlist.hpp"

DataPointList::DataPointList(CalcEngine *p_Engine, QObject *parent, const char *name):QObject(parent,name){
  setAutoDelete(TRUE);
  d_Engine=p_Engine;
}

void DataPointList::addNewDataPoint(float p_X, float p_Y, bool p_update){
  DataPoint *l_DataPoint=new DataPoint;
  l_DataPoint->position.setX(p_X);
  l_DataPoint->position.setY(p_Y);

  append(l_DataPoint);
  update(count()-1);	//count()-1 is the end of the list, so use the
			//update command to reduce code repetition
  if(p_update){
    emit NewItemAdded(last());//Tell the world...
    emit ListChanged();//Scream Some More
  };
}

void DataPointList::update(int p_Index){
  DataPoint *l_DP=at(p_Index);
  CalcEngine::Flow l_Flow=d_Engine->calcPoint(l_DP->position.x(),
					      l_DP->position.y());
 
  l_DP->uX=l_Flow.U;
  l_DP->uY=l_Flow.V;
  l_DP->pressure=l_Flow.P;
}

void DataPointList::updateall(){
  for(uint i=0;i<count();i++) update(i);
  emit(Updated());
  emit(ListChanged());
}

void DataPointList::change(int Index,float X, float Y){
  DataPoint *l_DP=at(Index);
  l_DP->position.setX(X);
  l_DP->position.setY(Y);
  update(Index);
  emit(ListChanged());
}
//ENDPRETTY

/*
 * Local variables:
 *  compile-command: "cd ..;make -k"
 * End:
 */
