/* qcolorpicker.h

Copyright (c) 1997 R. Michael Sharkey (msharkey@softarc.com)

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL R. MICHAEL SHARKEY BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

*/
//STARTPRETTY

#ifndef PFCOLORPICKER_HPP
#define PFCOLORPICKER_HPP 1
#include <qapp.h>
#include <qwidget.h>
#include <qdialog.h>
#include <qcolor.h>
#include <qpalette.h>
#include <qfontmet.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qrangect.h>
#include <qscrbar.h>
#include <qpainter.h>
#include <qstring.h>

#define ColorPaletteWidth	8
#define	ColorPaletteHeight	8

class QColorPicker : public /* QWidget */ QDialog {
Q_OBJECT
public:
 QColorPicker(QWidget *parent,const char *name);
 ~QColorPicker(void);
 QColor		getSelectedColor(void) {return colorSelected;}
private slots:
 void buttonClicked(int);
 void rgbSliderMoved(int);
 void rgbSliderPaged();
protected:
 void paintEvent(QPaintEvent *);
private:
 void initializePalette(void);// create standard color palette
 int lastButtonPressed;
 bool colorIsValid;
 QColor colorSelected;
 QColor	colorPalette[ColorPaletteWidth][ColorPaletteHeight];
 QButtonGroup *colorButtons;		// color cells
 QButtonGroup *controlButtons;	// OK, Cancel, etc
 QScrollBar *redSlider;
 QScrollBar *greenSlider;
 QScrollBar *blueSlider;
 QRect *sampleRect;		// sample area rectangle
 QRect *sliderRect;		// RGB slider container rect
 QPushButton *okButton;
 QPushButton *cancelButton;
};

#endif
//ENDPRETTY
