/*  
    PFlow 2.5: A potential flow demonstrator for fluid dynamics eduation
    Copyright (C) 1998  Craig P. Earls

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

//STARTPRETTY

#ifndef PFCALCENGINE_H
#define PFCALCENGINE_H 1

#include "pffpoint.hpp"
#include "pfsinglist.hpp"
#include "pfstreamlist.hpp"

class CalcEngine {
public:

  CalcEngine( SingList *SingularityList, float DeltaT);
  struct Velocity { 
    float U; 
    float V; 
  };

  struct Flow { 
    float U;
    float V;
    float P;
  };

  Velocity calcVelocity(float X, float Y);
  Flow calcPoint(float X, float Y);
  float calcPointSpeed(float X, float Y);
  float calcPointPressure(float X, float Y);
  void calcStreamline(Streamline *l_Streamline);
  void calcStreamlines(StreamList *l_StreamlineListl);
  // bool plotPressure(QPainter *p);

private:

  float d_DeltaT;
  const float d_Epsilon=0.02;
  float d_FreeX;
  float d_FreeY;

  SingList *d_SingularityList;

 

  void setFreeStream();
#ifndef PI  //This silliness is because some compilers don't define PI
  const float PI=3.1415926535;
#endif//PI
}   ;

#endif
//ENDPRETTY
/*
 * Local variables:
 *  compile-command: "cd ..;make -k"
 * End:
 */
