#include "qwt_plot.h"
#include "qwt_plot_item.h"
//------------------------------------------------------------
//
//.F	QwtPlotItem::QwtPlotItem
//
//
//.u	Parameters
//.p	QwtPlot *parent
//
//.u	Return Type
//		
//
//.u	Return Value
//
//.u	Description
//
//.u	Syntax
//.f	 QwtPlotItem::QwtPlotItem(QwtPlot *parent)
//
//------------------------------------------------------------
QwtPlotItem::QwtPlotItem(QwtPlot *parent, bool nbl)
{
    d_parent = parent;
    d_enabled = nbl;
}

//------------------------------------------------------------
//
//.F	QwtPlotItem::itemChanged
//
//
//.u	Parameters
//.p	
//
//.u	Return Type
//		void
//
//.u	Return Value
//
//.u	Description
//
//.u	Syntax
//.f	void QwtPlotItem::itemChanged()
//
//------------------------------------------------------------
void QwtPlotItem::itemChanged()
{
    d_parent->autoRefresh();
}

//------------------------------------------------------------
//
//.F	QwtPlotMappedItem::setXAxis
//
//
//.u	Parameters
//.p	int axis
//
//.u	Return Type
//		void
//
//.u	Return Value
//
//.u	Description
//
//.u	Syntax
//.f	void QwtPlotMappedItem::setXAxis(int axis)
//
//------------------------------------------------------------
void QwtPlotMappedItem::setXAxis(int axis)
{
    if (QwtPlot::axisValid(axis))
       d_xAxis = axis;
    itemChanged();    
}

//------------------------------------------------------------
//
//.F	QwtPlotMappedItem::setYAxis
//
//
//.u	Parameters
//.p	int axis
//
//.u	Return Type
//		void
//
//.u	Return Value
//
//.u	Description
//
//.u	Syntax
//.f	void QwtPlotMappedItem::setYAxis(int axis)
//
//------------------------------------------------------------
void QwtPlotMappedItem::setYAxis(int axis)
{
    if (QwtPlot::axisValid(axis))
       d_yAxis = axis;
    itemChanged();   
}




