#include <qpainter.h>
#include "qwt_arrbtn.h"
#include "qwt_math.h"
#include "qwt_symbol.h"

//------------------------------------------------------------
//
//.H QwtArrowButton | 3 | 12/31/97 | Qwt Widget Library | Qwt Programmer's Manual
//
//.U NAME
//	QwtArrowButton
//
//.U SYNOPSIS
//	#include <qwt_arrbtn.h>
//
//.U DESCRIPTION
//	A push button with one or more filled triangles on its front.
//	An Arrow button can have 1 to 3 arrows in a row, pointing
//	up, down, left or right.
//
//.U INHERITED CLASSES
//	QPushButton
//
//
//.U PUBLIC MEMBERS 
//.R
//	QwtArrowButton::QwtArrowButton -- Constructor
//	QwtArrowButton::dir -- Return direction
//	QwtArrowButton::num -- Return number of arrows
//	QwtArrowButton::sizeHint -- Return size hint
//
//.U SIGNALS AND SLOTS
//
//    See Qt Manual on QPushButton
//
//.U PROTECTED MEMBERS 
//.R
//	QwtArrowButton::drawButtonLabel -- draw button label
//
//.-
//.U COPYING
//
//	Copyright (C) 1997  Josef Wilgen
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License, version 2,
//	as published by	the Free Software Foundation.
//	This program is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//	You should have received a copy of the GNU General Public License
//	along with this program; if not, write to the Free Software
//	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
// 	 
//------------------------------------------------------------

//------------------------------------------------------------
//.C MEMBER FUNCTION DESCRIPTION
//------------------------------------------------------------

static const int MaxNum = 3;

//------------------------------------------------------------
//
//.F	QwtArrowButton::QwtArrowButton
//	Constructor
//
//.u	Syntax
//.f	 QwtArrowButton::QwtArrowButton(int num, Direction dir, QWidget *parent, const char *name = 0)
//
//.u	Parameters
//.p	int num	--		Number of arrows
//	Direction dir --	Direction. One of QwtArrowButton::Up, QwtArrowButton::Down,
//				QwtArrowButton::Left, or QwtArrowButton::Right
//	QWidget *parent	--	parent widget
//	const char *name --	name
//
//------------------------------------------------------------
QwtArrowButton::QwtArrowButton(int num, Direction dir, QWidget *parent, const char *name)
: QPushButton(parent, name)
{
    d_num = qwtLim(num,1,MaxNum);
    d_dir = dir;
    setMinimumSize(10,10);
}

//------------------------------------------------------------
//
//.F	QwtArrowButton::dir
//	Return the direction of the arrows
//
//.u	Syntax
//.f	Direction QwtArrowButton::dir()
//
//------------------------------------------------------------

//------------------------------------------------------------
//
//.F	QwtArrowButton::drawButtonLabel
//	Draw the button label
//
//.u	Syntax
//.f	void QwtArrowButton::drawButtonLabel(QPainter *p)
//
//.u    Access
//	Protected
//
//.u	Parameters
//.p	QPainter *p
//
//.u	Description
//	See Qt Manual on QPushButton
//------------------------------------------------------------
void QwtArrowButton::drawButtonLabel(QPainter *p)
{
    QwtSymbol sym;
    
    int i,ws, hs, offs;
    
    QRect r = this->rect();
    QRect symRect[MaxNum];

    r.setHeight(r.height() - 4);
    r.setWidth(r.width() - 4);
    r.moveBy(2,2);
    
    switch(d_dir)
    {
    case Up:
	sym.setStyle(QwtSymbol::UTriangle);
	break;
    case Down:
	sym.setStyle(QwtSymbol::DTriangle);
	break;
    case Right:
	sym.setStyle(QwtSymbol::RTriangle);
	break;
    case Left:
	sym.setStyle(QwtSymbol::LTriangle);
	break;
    }

    switch(d_dir)
    {
    case Up:
    case Down:
	hs = qwtMin(r.height() / 3 - 1, r.width() / 2 - 2);
	ws = hs * 2 - 1;
	offs = (r.height() - d_num * hs) / 2;
	for (i = 0; i < d_num; i++)
	{
	    symRect[i] = QRect(r.left() + (r.width() - ws) / 2,
			       r.top() + offs + i * hs,
			       ws, hs);
	}
	break;

    case Left:
    case Right:
	ws = qwtMin(r.width() / 3 - 1, r.height() / 2 - 2);
	hs = ws * 2 - 1;
	offs = (r.width() - d_num * ws) / 2;
	for (i = 0; i < d_num; i++)
	{
	    symRect[i] = QRect(r.left() + offs + i * ws,
			       r.top() + (r.height() - hs) / 2,
			       ws, hs);
	}
	break;
    }

    sym.setPen(colorGroup().text());
    sym.setBrush(colorGroup().text());

    p->save();

    for (i=0; i<d_num;i++)
       sym.draw(p, symRect[i]);

    p->restore();
    
}

//------------------------------------------------------------
//
//.F	QwtArrowButton::num
//	Return the number of arrows
//
//.u	Syntax
//.f	int QwtArrowButton::num()
//
//------------------------------------------------------------

//------------------------------------------------------------
//
//.F	QwtArrowButton::sizeHint
//	Return a size hint
//
//.u	Syntax
//.f	QSize QwtArrowButton::sizeHint()
//
//.u	Description
//	See Qt manual on QWidget::sizeHint
//------------------------------------------------------------









