#ifndef QWT_WHEEL_H
#define QWT_WHEEL_H

#include <qwt_sldbase.h>
#include <math.h>
#include <qpixmap.h>


class QwtWheel : public QwtSliderBase
{

public:
    enum Orientation { Horizontal, Vertical };
private:

    //
    //  PRIVATE DATA
    //
    int minPos;
    int maxPos;
    double viewAngle;
    double totalAngle;
    int tickCnt;
    int d_intBorder;
    int d_borderWidth;
    int d_colorCnt;

    QPixmap d_pixmap;					// background pixmap
    QRect d_sliderRect;
    QColor *d_colors;
    
    Orientation d_orient;

    //
    // PRIVATE MEMBER FUNCTIONS
    //
    void createColors();
    void rebuildPixmap();
    void drawWheel(QPainter *p, const QRect &r);

public:
    //
    //  PUBLIC MEMBER FUNCTIONS
    //

    QwtWheel(QWidget *parent = 0, const char *name = 0);
    ~QwtWheel();

    
    void setTotalAngle (double angle);
    void setTickCnt(int cnt);
    void setOrientation(Orientation o);
    void setViewAngle(double angle);
    void setInternalBorder(int width);
    void setMass(double val);

private:

    void resizeEvent(QResizeEvent *e);
    void paintEvent(QPaintEvent *e);
    //
    // Functions required by QwtSliderBase  
    //
    void valueChange();
    double getValue(const QPoint &p);
    void getScrollMode( const QPoint &p, int &scrollMode, int &direction);
    
};

#endif


















