#ifndef QWT_SCALE_IF_H
#define QWT_SCALE_IF_H

#include <qglobal.h>
#include <qwt_scldraw.h>


class QwtScaleIf
{

private:
	bool d_userScale;

protected:

	QwtScaleDraw d_scale;
	int d_maxMajor;
	int d_maxMinor;
   
public:

	QwtScaleIf();
	
	void setScale (double vmin, double vmax, int logarithmic = 0);
	void setScale (double vmin, double vmax, double step, int logarithmic = 0);
	void setScale(const QwtScaleDiv &s);
	void setScaleMaxMajor( int ticks);
	void setScaleMaxMinor( int ticks);
	void autoScale();

	int scaleMaxMinor() const {return d_maxMinor;}
	int scaleMaxMajor() const {return d_maxMinor;}

protected:

	bool hasUserScale() {return d_userScale;}
	virtual void scaleChange() = 0;
};




#endif















