#ifndef QWT_SCLDRAW_H
#define QWT_SCLDRAW_H

#include <qglobal.h>
#include <qstring.h>
#include <qwt_dimap.h>
#include <qwt_scldiv.h>
#include <qfont.h>
#include <qrect.h>
#include <qcolor.h>

class QPainter;
class QwtAutoScale;

class QwtScaleDraw
: public QwtDiMap
{
	
public:
    enum Orientation { Bottom, Top, Left, Right, Round };

private:

    QwtScaleDiv d_scldiv;
	
    static const int minLen;
	
    Orientation d_orient;
	
    int d_xorg;
    int d_yorg;
    int d_len;
	
    int d_hpad;
    int d_vpad;
	
    int d_medLen;
    int d_majLen;
    int d_minLen;

    int d_minAngle;
    int d_maxAngle;

    double d_xCenter;
    double d_yCenter;
    double d_radius;

    char d_fmt;
    int d_prec;
	
private:

    void drawTick(QPainter *p, double val, int len) const;
    void drawBackbone(QPainter *p) const;
    void drawLabel(QPainter *p, double val) const;
	
public:
 
    // CREATORS
    QwtScaleDraw();
    
    // MANIPULATORS
    void setScale(const QwtScaleDiv &s);
    void setScale(double vmin, double vmax, int maxMajIntv, int maxMinIntv,
		  double step = 0.0, int logarithmic = 0);
    void setGeometry(int xorigin, int yorigin, int length, Orientation o);
    void setAngleRange(double angle1, double angle2);
    void setLabelFormat(char f, int prec);

    // ACCESSORS
    const QwtScaleDiv& scaleDiv() const { return d_scldiv; }
    Orientation orientation() const { return d_orient; }
    QRect maxBoundingRect(QPainter *p) const;
    int maxWidth(QPainter *p, bool worst = TRUE) const;
    int maxHeight(QPainter *p) const;
    int maxLabelWidth(QPainter *p, int worst = TRUE) const;
    void draw(QPainter *p) const;
    
};

#endif







