#ifndef QWT_PIXFRAME_H
#define QWT_PIXFRAME_H

#include <qframe.h>
#include <qpixmap.h>
#include <qpen.h>
#include <qwt.h>

class QwtPixFrame : public QFrame
{

    Q_OBJECT

private:
    
    QColor d_bg;
       
protected:

    QPixmap d_pix;
    bool d_adjustPixmap;
    
public:

    QwtPixFrame (QWidget *parent, const char *name =0);
    ~QwtPixFrame();

    void setPixmap(const QPixmap &pix);
    const QPixmap *pixmap() const { return &d_pix; }
    void fillPixmap(const QColor &c);
    void clearPixmap();
    void updatePixmap();
    void updatePixmapRect(const QRect &r);
    void setPixmapBackground(const QColor &c);
    void setVariableSize(bool tf);
    const QColor &pixmapBackground() const {return d_bg;}
    
protected:

    void adjustPixmap();
    void adjustFrame();
    virtual void paintEvent(QPaintEvent *e);
    virtual void resizeEvent(QResizeEvent *e);
    virtual void frameChanged();

signals:

    void pixmapResized();
};
    


#endif








