#ifndef QWT_LEGEND_H
#define QWT_LEGEND_H

#include <qwt_symbol.h>
#include <qstring.h>
#include <qlist.h>
#include <qtablevw.h>
#include <qpen.h>

class QPainter;

class QwtLegendItem
{
	
private:

    
    QPen d_pen;
    QwtSymbol d_sym;
    QString d_text;
    long d_key;

public:

    QwtLegendItem();
    QwtLegendItem(const QString &txt, const QwtSymbol &sym, const QPen &pn, long key);

    const QPen& pen() { return d_pen; }
    const QwtSymbol& symbol() { return d_sym; }
    const QString& text() const { return d_text; }
    long key() const { return d_key; }

    void setSymbol(const QwtSymbol &s) {d_sym = s;}
    void setPen(const QPen &pn) {d_pen = pn;}
    void setKey(long key) {d_key = key; }
    void setText(const QString &s) {d_text = s;}
    
    void draw(QPainter *p, const QRect &symRect, const QRect& lblRect, int align);
    
};



class QwtLegend : public QTableView
{
    Q_OBJECT
private:

    int d_align;
    QRect d_symRect;
    QRect d_lblRect;
    int d_maxCols;
    int d_maxRows;

    struct selection 
    {
	bool active;
	int r;
	int c;
    } d_sel;

    uint findIndex(int row, int col);
    void QwtLegend::findRowCol(uint index, int &row, int &col);

protected:

    
    QList<QwtLegendItem> d_item;
    void paintCell(QPainter *p, int row, int col);
    void mousePressEvent(QMouseEvent *e);
    void mouseReleaseEvent(QMouseEvent *e);
    void resizeCells();
    void resizeTable();
    void updateTable();

public:

    QwtLegend(QWidget *w = 0, const char *name = 0);
    ~QwtLegend();
    
    bool insertItem(const QString &txt, const QwtSymbol &s, const QPen &p,
		    long key, uint index);
    uint appendItem(const QString &txt, const QwtSymbol &s, const QPen &p, long key);
    
    bool setText(uint index, const QString &s);
    bool setSymbol(uint index,  const QwtSymbol &s);
    bool setPen(uint index, const QPen &pn);
    bool setKey(uint index, long key);

    long key(uint index);
    bool removeItem(uint index);

    void setMaxCols(int n);
    void setMaxRows(int n);

    int colWidth() const { return cellWidth(); }
    int rowHeight() const { return cellHeight(); }
	
    void clear();
    QSize sizeHint() const;
    uint itemCnt() const { return d_item.count(); }
    uint findFirstKey(long key);

protected:
    virtual void fontChange(const QFont &oldFont);

signals:
    
    void pressed(int index);
    void clicked(int index);
    
    
};



#endif
