
#ifndef QWT_CURVE_H
#define QWT_CURVE_H

#include <qglobal.h>
#include <qpen.h>
#include <qstring.h>
#include <qrect.h>
#include <qcolor.h>
#include <qpntarry.h>
#include <qarray.h>
#include <qwt_dimap.h>
#include <qwt_spline.h>
#include <qwt_symbol.h>
#include <qwt.h>

class QPainter;

class QwtCurve 
{
    
public:


    enum { Auto = 0, Yfx = 1, Xfy = 2, Parametric = 4,
	   Periodic = 8, Inverted = 16};
    enum CurveStyle{ NoCurve, Lines, Sticks, Steps, Dots, Spline };

private:

    int *refcnt;
    double d_ref;
    
    QwtDiMap d_xMap;
    QwtDiMap d_yMap;
    QwtSymbol d_sym;
    QwtSpline d_spx;
    QwtSpline d_spy;
    
protected:
    
    QPen d_pen;
    QString d_title;
    QPointArray d_pa;
    
    QArray<double> d_x;
    QArray<double> d_y;
    
    int d_options;
    int d_splineSize;
    
    
private:

    // DATA MEMBERS
    CurveStyle d_style;

    bool d_xraw;
    bool d_yraw;
    
    void init(const char *title);
    void copy(const QwtCurve &c);

    // PRIVATE DRAWING FUNCTIONS
    void drawLines(QPainter &p, int i1 = -1, int i2 = -1);
    void drawSticks(QPainter &p, int i1 = -1, int i2 = -1);
    void drawDots(QPainter &p, int i1 = -1, int i2 = -1);
    void drawSteps(QPainter &p, int i1 = -1, int i2 = -1);
    void drawSymbols(QPainter &p, int i1 = -1, int i2 = -1);
    void drawSpline(QPainter &p);
    void transform(double x, double y, int &u, int &v);
    
public:

    // CREATORS
    QwtCurve(const char *title = 0);
    QwtCurve(const QwtCurve &c);
    virtual ~QwtCurve();

    // OPERATORS
    const QwtCurve& operator= (const QwtCurve &c);
    
    // MANIPULATORS
    void draw(QPainter *p, const QwtDiMap &xMap, const QwtDiMap &yMap);
    void draw(QPainter *p, const QRect &r);
    void draw(QPainter *p);
    void drawIntv(QPainter *p, int i1, int i2);
    void setData(double *x, double *y, int size);
    void setMap(const QRect &r, double x1, double x2, bool xlog,
		double y1, double y2, bool ylog);
    void setMap(const QwtDiMap &mx, const QwtDiMap& my);
    void setOptions(int t);
    void setPen(const QPen &p);
    void setRange(double x1, double x2, bool xlog,
		double y1, double y2, bool ylog);
    void setRawData(double *x, double *y, int size);
    void setRect(const QRect &r);
    void setBaseline(double ref);
    void setStyle(CurveStyle cs, int options = 0);
    void setSymbol(const QwtSymbol &s);
    void setSplineSize(int s);
    void setTitle(const char *title);
    

    // ACCESSORS
    double baseline() const { return d_ref; }
    int dataSize() const;
    double minXValue() const;
    double maxXValue() const;
    double minYValue() const;
    double maxYValue() const;

    int options() const { return d_options; }
    const QPen& pen() const { return d_pen; }
//    double reference() const { return d_ref; } // for compatibility with older
					       // versions; renamed to baseline
    int splineSize() const { return d_splineSize; }
    CurveStyle style() const { return d_style; }
    const QwtSymbol& symbol() const { return d_sym; }
    const QString &title() const { return d_title; } 

    double x(int i) const { return d_x[i]; }
    double y(int i) const { return d_y[i]; }
    
    

protected:
    virtual void curveChanged() {}
    int verifyRange(int &i1, int &i2);
    
};


#endif




