#ifndef QWT_AUTOSCL_H
#define QWT_AUTOSCL_H
#include <qglobal.h>
#include <qwt_scldiv.h>

class QwtAutoScale 
{

public:
    
    enum {None = 0, IncludeRef = 1, Symmetric = 2, Floating = 4,
	  Logarithmic = 8, Inverted = 16 };
    
protected:

    QwtScaleDiv d_scldiv;
    
    double d_minValue;			// smallest input value
    double d_maxValue;			// greatest input value

    double d_scaleMin;			// scale minimum
    double d_scaleMax;			// scale maximum
    
    double d_step;			// user-defined step size
    int d_maxMajor;			// max. no. of scale divisions
    int d_maxMinor;			// max. number of minor intervals

    int d_scaleOpt;			// scale options
    bool d_autoScale;			// autoscale mode
    
    double d_loMargin;			// margins
    double d_hiMargin;

    int d_reset;			// d_minValue and d_maxValue are invalid
    double d_ref;			// reference point
    double d_lref;			// special reference point for logarithmic scales

    bool d_autoRebuild;			// rebuild scale automatically with
					// call to 'adjust'
    
    void buildLinScale();
    void buildLogScale();
    void setRange(double x1, double x2);



public:


    //
    // CREATORS 
    //
    QwtAutoScale();				// Constructor
    ~QwtAutoScale();				// Destructor 

    //
    // MANIPULATORS
    //
    void adjust( double *arr, int n, int reset = 0);	// Extend scale
    void adjust( double x1, double x2, int reset = 0);	// Extend scale
    void build();				// Rebuild scale 
    void changeOptions(int opt, bool tf);	// Change a set of options
    void reset();				// clear scale  
    void setAutoRebuild(bool tf) { d_autoRebuild = tf; } // enable automatic update
    void setAutoScale();			// Enable autoscale mode 
    void setMargins(double m1, double m2);	// Specify margins
    void setMaxMajor( int n );			// Set max. number of major intervals
    void setMaxMinor(int n);			// Set max.number of minor intervals
    void setOptions(int opt);			// Specify options
    void setReference(double r);		// Specify a reference point
    void setScale(double xmin, double xmax, double step = 0.0);	// Set user-defined scale 

    //
    // ACCESSORS
    //
    bool autoScale() const { return d_autoScale; }	// Check for autoscale mode
    double loMargin() const { return d_loMargin; }	// Return lower margin
    double hiMargin() const { return d_hiMargin; }	// Return upper margin
    int maxMajor() const { return d_maxMajor; }		// Return max. number of major steps
    int maxMinor() const { return d_maxMinor; }		// Return max. number of minor steps
    bool option(int opt) const;				// check for specified option
    int options() const { return d_scaleOpt; }		// return options
    double reference() const { return d_ref; }		// return reference value
    const QwtScaleDiv &scaleDiv() const { return d_scldiv; }; // return scale division

};



#endif








