#include <qapp.h>
#include <qwidget.h>
#include <qwt_plot.h>

//-----------------------------------------------------------------
//		simple.cpp
//
//	A simple example which shows how to use QwtPlot
//-----------------------------------------------------------------

class MainWin : public QWidget
{
private:
    QwtPlot *plot;
public:
    MainWin();
    ~MainWin();
    void resizeEvent(QResizeEvent *e);
};


MainWin::MainWin()
: QWidget(0,0)
{
    
    int i;
    long cSin, cCos;
    long mX, mY;

    // Allocate the QwtPlot widget 
    plot = new QwtPlot("A Simple QwtPlot Demonstration", this);

    if (!plot) exit(-1);

    //
    //  Calculate some values
    //
    double *x = new double[100];
    double *y = new double[100];
    double *z = new double[100];

    for (i = 0; i< 100; i++)
    {
	x[i] = 0.1 * double(i);
	y[i] = sin(x[i]);
	z[i] = cos(x[i]);
    }


    // Insert new curves
    cSin = plot->insertCurve("y = sin(x)");
    cCos = plot->insertCurve("y = cos(x)");

    // Set curve styles
    plot->setCurvePen(cSin, QPen(red));
    plot->setCurvePen(cCos, QPen(blue));

    // Copy the data	
    plot->setCurveData(cSin, x, y, 100);
    plot->setCurveData(cCos, x, z, 100);

    // Insert markers
    
    //  ...a horizontal line at y = 0...
    mY = plot->insertLineMarker("y = 0", QwtPlot::yLeft);     
    plot->setMarkerYPos(mY, 0.0);

    //  ...a vertical line at x = 2 * pi
    mX = plot->insertLineMarker("x = 2 pi", QwtPlot::xBottom);
    plot->setMarkerXPos(mX, 6.284);

    // Set axis titles
    plot->setAxisTitle(QwtPlot::xBottom, "x -->");
    plot->setAxisTitle(QwtPlot::yLeft, "y -->");
    
    // We want a legend
    plot->enableLegend(TRUE);

    // arrays can be deleted safely, since setCurveData 
    //  has copied the values.
    delete[] x;
    delete[] y;
    delete[] z;
    
    
}

MainWin::~MainWin()
{
    delete plot;
}

void MainWin::resizeEvent(QResizeEvent *e)
{
    plot->resize(e->size());
    plot->move(0,0);
}

int main(int argc, char **argv)
{
    QApplication a(argc, argv);
    MainWin w;
    a.setMainWidget(&w);
    w.show();
    return a.exec(); 
}













