#include <qwidget.h>
#include <qframe.h>
#include <qpushbt.h>

class QwtPlot;
class QwtCounter;
class QLabel;
class QwtPlot;


class InputFrame : public QFrame
{

public:

    QLabel *lblDamp;
    QwtCounter *cntDamp;
    QLabel *lblInfo;
    QPushButton *btnPrint;
    QPushButton *btnZoom;    

    InputFrame(QWidget *p = 0, const char *name = 0);
    ~InputFrame();

};


class MainWin : public QWidget
{
    Q_OBJECT

   private:

    double damping;
    double *frequency;
    double *amplitude;
    double *phase;

    QwtPlot *plt;
    InputFrame *frmInp;
    QPoint p1;
    int d_zoom;
    int d_zoomActive;

    long crv1, crv2;
    long mrk1, mrk2;
    
public:
    
    MainWin(QWidget *p = 0, const char *name = 0);
    ~MainWin();

protected:
    
    void recalc();
    void resizeEvent(QResizeEvent *e);

    private slots:

    void plotMousePressed(const QMouseEvent &e);
    void plotMouseReleased(const QMouseEvent &e);
    void plotMouseMoved(const QMouseEvent &e);
    
    void print();
    void zoom();
    void setDamp(double d);

};








