/*
 * Copyright (C) 1997-1998 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * This file is part of QdbtTabular 0.31.
 */

#ifndef _QDBTTABLE_H
#define _QDBTTABLE_H

#include <qtablevw.h>
#include <qarray.h>

#include "qdbtcellmatrix.h"

class QdbtTabular;
class QLineEdit;
class QdbtDynaTip;

struct RowInfo
{
  int height;        // the height of the row
  bool selected;     // whether or not the row is selected
  bool selectable;   // whether or not the row is selectable by the user
};

class QdbtTable : public QTableView
{
  friend class QdbtTabular;
  friend class QdbtDynaTip;
  friend class QdbtLineEdit;

  enum { NoScroll=0, ScrollDown=1, ScrollUp=2 ,ScrollLeft=4, ScrollRight=8 };

  Q_OBJECT

  public:
    QdbtTable(QWidget *parent=0,const char *name=0);
    virtual ~QdbtTable();
    int   numRows() { return cells.rows(); }
    int   numCols() { return cells.cols(); }
    void  insertCol(int c);
    void  removeCol(int c);
    void  insertRow(int r,bool selectable=TRUE);
    void  removeRow(int r);
    void  changeCell(const QdbtTableCell *tc,int row,int col);
    void  setDimensions(int rows,int cols);
    int   columnWidth(int col) const;
    int   rowHeight(int row) const;
    int   columnWidthHint(int col);
    const QdbtTableCell *cell(int row,int col);
    bool  rowSelected(int row) const;
    void  setRowSelected(int row,bool status);
    void  setFont(const QFont &font);
    void  enableTooltips();
    void  disableTooltips();
    void  selectByRow(bool enable) { selectRows=enable; }
    bool  rowSelectable(int row) const;
    void  setRowSelectable(int row,bool enable);
    void  editCell(int row,int col);
    void  exposeCell(int row,int col);

  protected:
    void mousePressEvent(QMouseEvent *);
    void mouseReleaseEvent(QMouseEvent *);
    void mouseMoveEvent(QMouseEvent *);
    void mouseDoubleClickEvent(QMouseEvent *);
    void enterEvent(QEvent *);
    void leaveEvent(QEvent *);
    void timerEvent(QTimerEvent *);
    void keyPressEvent(QKeyEvent *);
    void keyReleaseEvent(QKeyEvent *);
    void focusInEvent(QFocusEvent *);
    void focusOutEvent(QFocusEvent *);
    void updateRow(int row);
    void paintCell(QPainter*, int row, int col);
    void resizeEvent(QResizeEvent *);
    void paintEvent(QPaintEvent *);
    void setPalette(const QPalette &);
    int  cellWidth(int);
    int  cellHeight(int);
    int  cellXOffset(int);
    int  cellYOffset(int);
 
  public slots:
    void setColumnWidth(int c,int w);
    void setTableOffset(int);
    void updateTable();
    void exposeColumn(int);
 
  signals:
    void setHeaderOffset(int);
    void selected(int,bool);
    void activated(int);
    void cellEdited(int,int);
    void cellSelected(int,int,bool);
    void cellActivated(int,int);

  private slots:
    void cellEditDone();

  private:  
    void resetFocus(int row,int col,bool enable,bool expose);
    void markRange(int start,int end);
    void markBlock(int startRow,int startCol,int endRow,int endCol);
    QRect needsTip(const QPoint &pos,QString &text);
    QdbtTabular     *parent;
    QdbtLineEdit    *cellEditor;
    QArray<int>      columnAligns;
    QArray<int>      columnWidths;   
    QArray<RowInfo>  rowInfo;
    QdbtCellMatrix   cells;
    bool dragging;
    int startDragRow;
    int startDragCol;
    int scrollDirection;
    bool timerRunning;
    QPoint mouseAt;
    int editingRow;
    int editingCol;
    bool editingEnabled;
    bool selectRows;
    QdbtDynaTip *tip;
    int currentFocusRow;
    int currentFocusCol;
    bool focusActive;
};

#endif
