/*
 * Copyright (C) 1997-1998 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * This file is part of QdbtTabular 0.31.
 */

#ifndef _QSLIDEBAR_H
#define _QSLIDEBAR_H

#include <qwidget.h>

class QdbtSlideBar: public QWidget
{
  Q_OBJECT

  public:
    QdbtSlideBar(QWidget *parent=0,const char *name=0);
   ~QdbtSlideBar();
    void     updateBar(const QPoint &p);
    void     setBounds(int x,int y,int w,int h) { setBounds(QRect(x,y,w,h)); }
    void     setBounds(const QRect &r);
    void     setBarWidth(int w) { barWidth=w; setBounds(bounds); }
  signals:
    void     sliderPos(int);
  protected:
    void     mouseReleaseEvent(QMouseEvent *); 
    void     mouseMoveEvent(QMouseEvent *);
  private:
    QWidget *controlWidget;
    QRect    bounds;
    int      barWidth;
    int      sliderXPos;
};

#endif _QSLIDEBAR_H
